/*
 * Decompiled with CFR 0.152.
 */
package org.mage.plugins.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.List;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import mage.client.dialog.PreferencesDialog;
import mage.components.ImagePanel;
import mage.components.ImagePanelStyle;
import mage.interfaces.plugin.ThemePlugin;
import mage.util.RandomUtil;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.PluginLoaded;
import net.xeoh.plugins.base.annotations.meta.Author;
import org.apache.log4j.Logger;

@PluginImplementation
@Author(name="nantuko")
public class ThemePluginImpl
implements ThemePlugin {
    private static final Logger log = Logger.getLogger(ThemePluginImpl.class);
    private static BufferedImage background;
    private final List flist = new List();
    private final String BackgroundDir = "backgrounds" + File.separator;

    @PluginLoaded
    public void newPlugin(ThemePlugin plugin) {
        log.info((Object)(plugin.toString() + " has been loaded."));
    }

    public String toString() {
        return "[Theme plugin, version 0.5]";
    }

    public boolean loadimages() {
        File filedir = new File(this.BackgroundDir);
        File[] filelist = filedir.listFiles();
        if (filelist == null) {
            return false;
        }
        if (filelist.length == 0) {
            return false;
        }
        for (File f : filelist) {
            String filename = f.getName().toLowerCase(Locale.ENGLISH);
            if (filename == null || !filename.endsWith(".png") && !filename.endsWith(".jpg") && !filename.endsWith(".bmp")) continue;
            this.flist.add(filename);
        }
        return this.flist.getItemCount() != 0;
    }

    public void applyInGame(Map<String, JComponent> ui) {
        try {
            BufferedImage backgroundImage = PreferencesDialog.getCachedValue("battlefieldImageDefault", "true").equals("true") ? this.loadbuffer_default() : (PreferencesDialog.getCachedValue("battlefieldImagerandom", "true").equals("true") ? this.loadbuffer_random() : (PreferencesDialog.getCachedValue("battlefieldImage", "") != null ? this.loadbuffer_selected() : this.loadbuffer_default()));
            if (backgroundImage == null) {
                backgroundImage = this.loadbuffer_default();
            }
            if (backgroundImage == null) {
                throw new FileNotFoundException("Couldn't find in resources.");
            }
            if (ui.containsKey("gamePanel") && ui.containsKey("jLayeredPane")) {
                ImagePanel bgPanel = new ImagePanel(backgroundImage, ImagePanelStyle.TILED);
                this.unsetOpaque(ui.get("splitChatAndLogs"));
                this.unsetOpaque(ui.get("splitHandAndStack"));
                this.unsetOpaque(ui.get("splitBattlefieldAndChats"));
                this.unsetOpaque(ui.get("splitGameAndBigCard"));
                this.unsetOpaque(ui.get("pnlBattlefield"));
                this.unsetOpaque(ui.get("pnlHelperHandButtonsStackArea"));
                this.unsetOpaque(ui.get("hand"));
                this.unsetOpaque(ui.get("gameChatPanel"));
                this.unsetOpaque(ui.get("userChatPanel"));
                ui.get("gamePanel").remove(ui.get("jLayeredPane"));
                bgPanel.add(ui.get("jLayeredPane"));
                ui.get("gamePanel").add((Component)bgPanel);
            } else {
                log.error((Object)"error: no components");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private BufferedImage loadbuffer_default() throws IOException {
        InputStream is = this.getClass().getResourceAsStream(PreferencesDialog.getCurrentTheme().getBattleBackgroundPath());
        BufferedImage res = ImageIO.read(is);
        return res;
    }

    private BufferedImage loadbuffer_random() throws IOException {
        if (this.loadimages()) {
            int it = (int)Math.abs(RandomUtil.nextDouble() * (double)this.flist.getItemCount());
            String filename = this.BackgroundDir + this.flist.getItem(it);
            BufferedImage res = ImageIO.read(new File(filename));
            return res;
        }
        return null;
    }

    private BufferedImage loadbuffer_selected() throws IOException {
        String path = PreferencesDialog.getCachedValue("battlefieldImage", "");
        if (path != null && !path.isEmpty()) {
            try {
                BufferedImage res = ImageIO.read(new File(path));
                return res;
            }
            catch (Exception e) {
                Object var1_3 = null;
            }
        }
        return null;
    }

    public JComponent updateTable(Map<String, JComponent> ui) {
        ImagePanel bgPanel = this.createImagePanelInstance();
        this.unsetOpaque(ui.get("jScrollPane1"));
        this.unsetOpaque(ui.get("jPanel1"));
        this.unsetOpaque(ui.get("tablesPanel"));
        JComponent viewport = ui.get("jScrollPane1ViewPort");
        if (viewport != null) {
            viewport.setBackground(new Color(255, 255, 255, 50));
        }
        return bgPanel;
    }

    private synchronized ImagePanel createImagePanelInstance() {
        if (background == null) {
            try {
                if (PreferencesDialog.getCachedValue("backgroundImagedDefault", "true").equals("true")) {
                    InputStream is = this.getClass().getResourceAsStream(PreferencesDialog.getCurrentTheme().getBackgroundPath());
                    if (is == null) {
                        throw new FileNotFoundException("Couldn't find " + PreferencesDialog.getCurrentTheme().getBackgroundPath() + " in resources.");
                    }
                    background = ImageIO.read(is);
                } else {
                    String path = PreferencesDialog.getCachedValue("backgroundImage", "");
                    if (path != null && !path.isEmpty()) {
                        try {
                            File f = new File(path);
                            if (f != null) {
                                background = ImageIO.read(f);
                            }
                        }
                        catch (Exception e) {
                            background = null;
                        }
                    }
                }
                if (background == null) {
                    String filename = "/background/background.png";
                    InputStream is = this.getClass().getResourceAsStream(filename);
                    if (is == null) {
                        throw new FileNotFoundException("Couldn't find " + filename + " in resources.");
                    }
                    background = ImageIO.read(is);
                    if (background == null) {
                        throw new FileNotFoundException("Couldn't find " + filename + " in resources.");
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return new ImagePanel(background, ImagePanelStyle.SCALED);
    }

    private void unsetOpaque(JComponent c) {
        if (c != null) {
            c.setOpaque(false);
        }
    }
}

