/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;

public class Standard
extends Constructed {
    public Standard() {
        super("Constructed - Standard");
        this.setCodes.addAll(Standard.makeLegalSets());
        this.banned.add("Abuelo's Awakening");
        this.banned.add("Cori-Steel Cutter");
        this.banned.add("Heartfire Hero");
        this.banned.add("Hopeless Nightmare");
        this.banned.add("Monstrous Rage");
        this.banned.add("This Town Ain't Big Enough");
        this.banned.add("Up the Beanstalk");
    }

    static List<String> makeLegalSets() {
        GregorianCalendar current = new GregorianCalendar();
        Date earliestDate = Sets.getInstance().values().stream().filter(set -> !set.getReleaseDate().after(current.getTime())).filter(ExpansionSet::isRotationSet).sorted((Comparator<ExpansionSet>)ExpansionSet.getComparator()).skip(2L).findFirst().get().getReleaseDate();
        return Sets.getInstance().values().stream().filter(set -> set.getSetType().isStandardLegal()).filter(set -> !set.getReleaseDate().before(earliestDate)).map(ExpansionSet::getCode).collect(Collectors.toList());
    }
}

