/*
 * Decompiled with CFR 0.152.
 */
package mage.deck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;
import mage.cards.decks.Deck;

public class SuperType2
extends Constructed {
    private static final String[][] standards = new String[][]{{"7ED", "INV", "APC", "PLS", "ODY", "TOR", "JUD"}, {"7ED", "ODY", "TOR", "JUD", "ONS", "LGN", "SCG"}, {"8ED", "ODY", "TOR", "JUD", "ONS", "LGN", "SCG"}, {"8ED", "ONS", "LGN", "SCG", "MRD", "DST", "5DN"}, {"8ED", "MRD", "DST", "5DN", "CHK", "BOK", "SOK"}, {"9ED", "MRD", "DST", "5DN", "CHK", "BOK", "SOK"}, {"9ED", "CHK", "BOK", "SOK", "RAV", "GPT", "DIS", "CSP"}, {"9ED", "RAV", "GPT", "DIS", "CSP", "TSP", "TSB", "PLC", "FUT"}, {"10E", "RAV", "GPT", "DIS", "CSP", "TSP", "TSB", "PLC", "FUT"}, {"10E", "CSP", "TSP", "TSB", "PLC", "FUT", "LRW", "MOR", "SHM", "EVE"}, {"10E", "LRW", "MOR", "SHM", "EVE", "ALA", "CON", "ARB"}};

    public SuperType2() {
        super("Constructed - Super Type 2");
        this.banned.add("Ancient Den");
        this.banned.add("Disciple of the Vault");
        this.banned.add("Great Furnace");
        this.banned.add("Seat of the Synod");
        this.banned.add("Skullclamp");
        this.banned.add("Tree of Tales");
        this.banned.add("Vault of Whispers");
    }

    public boolean validate(Deck deck) {
        ArrayList leastInvalid = null;
        boolean valid = false;
        this.errorsList.clear();
        HashMap counts = new HashMap();
        this.countCards(counts, deck.getCards());
        this.countCards(counts, deck.getSideboard());
        if (counts.containsKey("Stoneforge Mystic") && counts.containsKey("Batterskull")) {
            return false;
        }
        for (String[] sets : standards) {
            this.errorsList.clear();
            this.setCodes = new ArrayList<String>(Arrays.asList(sets));
            if (this.setCodes.contains("MRD") || this.setCodes.contains("SOM")) {
                this.banned.add("Darksteel Citadel");
            } else {
                this.banned.remove("Darksteel Citadel");
            }
            if (super.validate(deck)) {
                valid = true;
                break;
            }
            if (leastInvalid == null) {
                leastInvalid = new ArrayList(this.getErrorsList());
                continue;
            }
            if (leastInvalid.size() <= this.getErrorsList().size()) continue;
            leastInvalid = new ArrayList(this.getErrorsList());
        }
        GregorianCalendar start = new GregorianCalendar(2006, 8, 1);
        GregorianCalendar end = new GregorianCalendar(2008, 8, 1);
        GregorianCalendar current = new GregorianCalendar();
        while (end.before(current) && !valid) {
            this.setCodes.clear();
            this.errorsList.clear();
            start.set(1, start.get(1) + 1);
            end.set(1, start.get(1) + 2);
            for (ExpansionSet set : Sets.getInstance().values()) {
                if (!set.getSetType().isStandardLegal() || !set.getReleaseDate().after(start.getTime()) || !set.getReleaseDate().before(end.getTime())) continue;
                this.setCodes.add(set.getCode());
            }
            if (this.setCodes.contains("MRD") || this.setCodes.contains("SOM")) {
                this.banned.add("Darksteel Citadel");
            } else {
                this.banned.remove("Darksteel Citadel");
            }
            if (super.validate(deck)) {
                this.errorsList.clear();
                valid = true;
                break;
            }
            if (leastInvalid == null) {
                leastInvalid = new ArrayList(this.getErrorsList());
                continue;
            }
            if (leastInvalid.size() <= this.getErrorsList().size()) continue;
            leastInvalid = new ArrayList(this.getErrorsList());
        }
        if (!valid) {
            this.errorsList = new ArrayList(leastInvalid);
        }
        return valid;
    }
}

