/*
 * Decompiled with CFR 0.152.
 */
package mage;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import org.apache.log4j.Logger;

public class MageObjectReference
implements Comparable<MageObjectReference>,
Serializable {
    private static final Logger logger = Logger.getLogger(MageObjectReference.class);
    private final UUID sourceId;
    private final int zoneChangeCounter;

    public MageObjectReference(MageObject mageObject, Game game) {
        this(mageObject, game, 0);
    }

    public MageObjectReference(MageObject mageObject, Game game, int offset) {
        if (mageObject == null) {
            this.sourceId = null;
            this.zoneChangeCounter = -1;
            return;
        }
        this.sourceId = mageObject.getId();
        this.zoneChangeCounter = mageObject.getZoneChangeCounter(game) + offset;
    }

    public MageObjectReference(UUID sourceId, int zoneChangeCounter, Game game) {
        this.sourceId = sourceId;
        this.zoneChangeCounter = zoneChangeCounter;
    }

    public MageObjectReference(UUID sourceId) {
        this.sourceId = sourceId;
        this.zoneChangeCounter = -1;
    }

    @Deprecated
    public MageObjectReference(Ability source) {
        this(source, 0);
    }

    @Deprecated
    public MageObjectReference(Ability source, int modifier) {
        this.sourceId = source.getSourceId();
        this.zoneChangeCounter = source.getStackMomentSourceZCC() + modifier;
    }

    public MageObjectReference(UUID sourceId, Game game) {
        this.sourceId = sourceId;
        if (sourceId == null) {
            this.zoneChangeCounter = -1;
            return;
        }
        MageObject mageObject = game.getObject(sourceId);
        if (mageObject != null) {
            this.zoneChangeCounter = mageObject.getZoneChangeCounter(game);
        } else if (game.getPlayerList().contains(sourceId)) {
            this.zoneChangeCounter = 0;
        } else {
            logger.error((Object)("The provided sourceId is not connected to an object in the game id: " + sourceId));
            for (StackObject stackObject : game.getStack()) {
                logger.error((Object)("StackObject: " + stackObject.getId() + " sourceId " + stackObject.getSourceId() + " name " + stackObject.getName()));
            }
            mageObject = game.getLastKnownInformation(sourceId, Zone.STACK);
            if (mageObject != null) {
                this.zoneChangeCounter = mageObject.getZoneChangeCounter(game);
                logger.error((Object)"SourceId found in LKI");
            } else {
                this.zoneChangeCounter = 0;
                logger.error((Object)"SourceId NOT found in LKI");
            }
        }
    }

    public String toString() {
        return "(" + this.zoneChangeCounter + "|" + this.sourceId.toString().substring(0, 3) + ")";
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public int getZoneChangeCounter() {
        return this.zoneChangeCounter;
    }

    @Override
    public int compareTo(MageObjectReference o) {
        if (o.getSourceId() == null || this.sourceId == null || Objects.equals(o.getSourceId(), this.sourceId)) {
            return Integer.compare(o.getZoneChangeCounter(), this.zoneChangeCounter);
        }
        return o.getSourceId().compareTo(this.sourceId);
    }

    public boolean equals(Object v) {
        if (v instanceof MageObjectReference && Objects.equals(((MageObjectReference)v).getSourceId(), this.sourceId)) {
            return ((MageObjectReference)v).getZoneChangeCounter() == this.zoneChangeCounter;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.sourceId != null ? this.sourceId.hashCode() + this.zoneChangeCounter : 0);
        return hash;
    }

    public boolean refersTo(UUID id, Game game) {
        return this.refersTo(game.getObject(id), game);
    }

    public boolean refersTo(MageObject mageObject, Game game) {
        return this.refersTo(mageObject, game, 0);
    }

    public boolean refersTo(MageObject mageObject, Game game, int offset) {
        if (mageObject == null) {
            return false;
        }
        if (mageObject instanceof Spell) {
            return Objects.equals(((Spell)mageObject).getSourceId(), this.sourceId) && this.zoneChangeCounter + offset == mageObject.getZoneChangeCounter(game);
        }
        return mageObject.getId().equals(this.sourceId) && this.zoneChangeCounter + offset == mageObject.getZoneChangeCounter(game);
    }

    public boolean refersTo(Ability source, Game game) {
        if (source == null || !source.getSourceId().equals(this.sourceId)) {
            return false;
        }
        return this.zoneChangeCounter * source.getStackMomentSourceZCC() == 0 || this.zoneChangeCounter == source.getStackMomentSourceZCC();
    }

    public Permanent getPermanent(Game game) {
        Permanent permanent = game.getPermanent(this.sourceId);
        if (permanent != null && permanent.getZoneChangeCounter(game) == this.zoneChangeCounter) {
            return permanent;
        }
        return null;
    }

    public Permanent getPermanentOrLKIBattlefield(Game game) {
        return game.getPermanentOrLKIBattlefield(this);
    }

    public Card getCard(Game game) {
        Card card = game.getCard(this.sourceId);
        if (card != null && card.getZoneChangeCounter(game) == this.zoneChangeCounter) {
            return card;
        }
        return null;
    }

    public Spell getSpell(Game game) {
        Spell spell = game.getSpell(this.sourceId);
        if (spell != null && spell.getZoneChangeCounter(game) == this.zoneChangeCounter) {
            return spell;
        }
        return null;
    }

    public boolean zoneCounterIsCurrent(Game game) {
        return game.getState().getZoneChangeCounter(this.sourceId) == this.zoneChangeCounter;
    }
}

