/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.abilities.AbilityImpl;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.Costs;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.hint.Hint;
import mage.abilities.icon.CardIcon;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.AbilityWord;
import mage.constants.CostModificationType;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;
import mage.target.targetadjustment.TargetAdjuster;
import mage.watchers.Watcher;

public interface Ability
extends Controllable,
Serializable {
    public void newId();

    public void newOriginalId();

    public AbilityType getAbilityType();

    public boolean isActivatedAbility();

    public boolean isTriggeredAbility();

    public boolean isNonManaActivatedAbility();

    public boolean isManaActivatedAbility();

    public boolean isManaAbility();

    public void setControllerId(UUID var1);

    public UUID getSourceId();

    public void setSourceId(UUID var1);

    default public void clearCosts() {
        this.getCosts().clear();
    }

    default public void clearManaCosts() {
        this.getManaCosts().clear();
    }

    default public void clearManaCostsToPay() {
        this.getManaCostsToPay().clear();
    }

    public Costs<Cost> getCosts();

    public void addCost(Cost var1);

    public ManaCosts<ManaCost> getManaCosts();

    default public List<String> getManaCostSymbols() {
        ArrayList<String> symbols = new ArrayList<String>();
        for (ManaCost cost : this.getManaCosts()) {
            symbols.add(cost.getText());
        }
        return symbols;
    }

    public ManaCosts<ManaCost> getManaCostsToPay();

    public void addManaCostsToPay(ManaCost var1);

    public void setVariableCostsMinMax(int var1, int var2);

    public void setVariableCostsValue(int var1);

    public Map<String, Object> getCostsTagMap();

    public void setCostsTag(String var1, Object var2);

    public Effects getEffects();

    public Effects getAllEffects();

    public Effects getEffects(Game var1, EffectType var2);

    public void addEffect(Effect var1);

    public Targets getTargets();

    public Targets getAllSelectedTargets();

    public UUID getFirstTarget();

    public void addTarget(Target var1);

    public Zone getZone();

    public boolean isUsesStack();

    public String getRule();

    public String getRule(boolean var1);

    public String getRule(String var1);

    public boolean activate(Game var1, Set<MageIdentifier> var2, boolean var3);

    default public boolean activate(Game game, boolean noMana) {
        return this.activate(game, new HashSet<MageIdentifier>(Arrays.asList(MageIdentifier.Default)), noMana);
    }

    public boolean isActivated();

    public boolean resolve(Game var1);

    public void reset(Game var1);

    public boolean checkIfClause(Game var1);

    public Ability copy();

    public boolean isModal();

    public void addMode(Mode var1);

    public Modes getModes();

    public boolean canChooseTarget(Game var1, UUID var2);

    public List<Ability> getSubAbilities();

    public void addSubAbility(Ability var1);

    public List<Watcher> getWatchers();

    public void addWatcher(Watcher var1);

    public boolean isInUseableZone(Game var1, MageObject var2, GameEvent var3);

    public boolean hasSourceObjectAbility(Game var1, MageObject var2, GameEvent var3);

    default public boolean hasTapCost() {
        for (Cost cost : this.getCosts()) {
            if (!(cost instanceof TapSourceCost)) continue;
            return true;
        }
        return false;
    }

    public boolean getRuleAtTheTop();

    public Ability setRuleAtTheTop(boolean var1);

    public boolean getWorksFaceDown();

    public void setWorksFaceDown(boolean var1);

    public boolean getWorksPhasedOut();

    public void setWorksPhasedOut(boolean var1);

    public boolean getRuleVisible();

    public Ability setRuleVisible(boolean var1);

    public boolean getAdditionalCostsRuleVisible();

    public void setAdditionalCostsRuleVisible(boolean var1);

    public UUID getOriginalId();

    public Ability setAbilityWord(AbilityWord var1);

    public Ability withFlavorWord(String var1);

    public String addRulePrefix(String var1);

    public Ability withFirstModeFlavorWord(String var1);

    public Ability withFirstModeCost(Cost var1);

    public String getGameLogMessage(Game var1);

    public boolean activateAlternateOrAdditionalCosts(MageObject var1, Set<MageIdentifier> var2, boolean var3, Player var4, Game var5);

    public MageObject getSourceObject(Game var1);

    public void setSourceObjectZoneChangeCounter(int var1);

    public void initSourceObjectZoneChangeCounter(Game var1, boolean var2);

    public int getStackMomentSourceZCC();

    public MageObject getSourceObjectIfItStillExists(Game var1);

    public Card getSourceCardIfItStillExists(Game var1);

    public Permanent getSourcePermanentIfItStillExists(Game var1);

    public Permanent getSourcePermanentOrLKI(Game var1);

    public void setSourcePermanentTransformCount(Game var1);

    public boolean checkTransformCount(Permanent var1, Game var2);

    public String getTargetDescription(Targets var1, Game var2);

    public void setCanFizzle(boolean var1);

    public boolean canFizzle();

    public Ability withCanBeCopied(boolean var1);

    public boolean canBeCopied();

    public Ability setTargetAdjuster(TargetAdjuster var1);

    public TargetAdjuster getTargetAdjuster();

    public void adjustTargets(Game var1);

    public Ability setCostAdjuster(CostAdjuster var1);

    public CostAdjuster getCostAdjuster();

    public void adjustX(Game var1);

    public void adjustCostsPrepare(Game var1);

    public void adjustCostsModify(Game var1, CostModificationType var2);

    public List<Hint> getHints();

    public Ability addHint(Hint var1);

    public void setModeTag(String var1);

    public List<CardIcon> getIcons();

    public List<CardIcon> getIcons(Game var1);

    public Ability addIcon(CardIcon var1);

    public Ability addCustomOutcome(Outcome var1);

    public Outcome getCustomOutcome();

    public boolean isSameInstance(Ability var1);

    public MageIdentifier getIdentifier();

    public AbilityImpl setIdentifier(MageIdentifier var1);
}

