/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.MageSingleton;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.AlternativeSourceCosts;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.EarlyTargetCost;
import mage.abilities.costs.MinMaxVariableCost;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.VariableCost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.hint.Hint;
import mage.abilities.icon.CardIcon;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.Card;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.AbilityType;
import mage.constants.AbilityWord;
import mage.constants.CostModificationType;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.events.BatchEvent;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.Targets;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetadjustment.GenericTargetAdjuster;
import mage.target.targetadjustment.TargetAdjuster;
import mage.util.CardUtil;
import mage.util.GameLog;
import mage.util.ThreadLocalStringBuilder;
import mage.watchers.Watcher;
import org.apache.log4j.Logger;

public abstract class AbilityImpl
implements Ability {
    private static final Logger logger = Logger.getLogger(AbilityImpl.class);
    private static final ThreadLocalStringBuilder threadLocalBuilder = new ThreadLocalStringBuilder(100);
    private static final List<Ability> emptyAbilities = new ArrayList<Ability>();
    protected UUID id;
    private UUID originalId;
    protected AbilityType abilityType;
    protected UUID controllerId;
    protected UUID sourceId;
    private final ManaCosts<ManaCost> manaCosts;
    private final ManaCosts<ManaCost> manaCostsToPay;
    private final Costs<Cost> costs;
    private final Modes modes;
    protected Zone zone;
    protected String name;
    protected AbilityWord abilityWord;
    protected String flavorWord;
    protected boolean usesStack = true;
    private boolean ruleAtTheTop = false;
    private boolean ruleVisible = true;
    private boolean ruleAdditionalCostsVisible = true;
    protected boolean activated = false;
    private boolean worksFaceDown = false;
    private boolean worksPhasedOut = false;
    private int sourceObjectZoneChangeCounter;
    private List<Watcher> watchers = new ArrayList<Watcher>();
    private List<Ability> subAbilities = null;
    private boolean canFizzle = true;
    private boolean canBeCopied = true;
    private TargetAdjuster targetAdjuster = null;
    private CostAdjuster costAdjuster = null;
    private List<Hint> hints = new ArrayList<Hint>();
    protected List<CardIcon> icons = new ArrayList<CardIcon>();
    private Outcome customOutcome = null;
    private MageIdentifier identifier = MageIdentifier.Default;
    private String appendToRule = null;
    private int sourcePermanentTransformCount = 0;
    private Map<String, Object> costsTagMap = null;

    protected AbilityImpl(AbilityType abilityType, Zone zone) {
        this.originalId = this.id = UUID.randomUUID();
        this.abilityType = abilityType;
        this.zone = zone;
        this.manaCosts = new ManaCostsImpl<ManaCost>();
        this.manaCostsToPay = new ManaCostsImpl<ManaCost>();
        this.costs = new CostsImpl<Cost>();
        this.modes = new Modes();
    }

    protected AbilityImpl(AbilityImpl ability) {
        this.id = ability.id;
        this.originalId = ability.originalId;
        this.abilityType = ability.abilityType;
        this.controllerId = ability.controllerId;
        this.sourceId = ability.sourceId;
        this.zone = ability.zone;
        this.name = ability.name;
        this.usesStack = ability.usesStack;
        this.manaCosts = ability.manaCosts.copy();
        this.manaCostsToPay = ability.manaCostsToPay.copy();
        this.costs = ability.costs.copy();
        this.watchers = CardUtil.deepCopyObject(ability.watchers);
        this.subAbilities = CardUtil.deepCopyObject(ability.subAbilities);
        this.modes = ability.getModes().copy();
        this.ruleAtTheTop = ability.ruleAtTheTop;
        this.ruleVisible = ability.ruleVisible;
        this.ruleAdditionalCostsVisible = ability.ruleAdditionalCostsVisible;
        this.worksFaceDown = ability.worksFaceDown;
        this.worksPhasedOut = ability.worksPhasedOut;
        this.abilityWord = ability.abilityWord;
        this.flavorWord = ability.flavorWord;
        this.sourceObjectZoneChangeCounter = ability.sourceObjectZoneChangeCounter;
        this.canFizzle = ability.canFizzle;
        this.canBeCopied = ability.canBeCopied;
        this.targetAdjuster = ability.targetAdjuster;
        this.costAdjuster = ability.costAdjuster;
        this.hints = CardUtil.deepCopyObject(ability.hints);
        this.icons = CardUtil.deepCopyObject(ability.icons);
        this.customOutcome = ability.customOutcome;
        this.identifier = ability.identifier;
        this.activated = ability.activated;
        this.appendToRule = ability.appendToRule;
        this.sourcePermanentTransformCount = ability.sourcePermanentTransformCount;
        this.costsTagMap = CardUtil.deepCopyObject(ability.costsTagMap);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void newId() {
        if (!(this instanceof MageSingleton)) {
            this.id = UUID.randomUUID();
        }
        this.getEffects().newId();
        for (Ability sub : this.getSubAbilities()) {
            sub.newId();
        }
    }

    @Override
    public void newOriginalId() {
        this.originalId = this.id = UUID.randomUUID();
        this.getEffects().newId();
    }

    @Override
    public AbilityType getAbilityType() {
        return this.abilityType;
    }

    @Override
    public boolean isActivatedAbility() {
        return this.abilityType.isActivatedAbility();
    }

    @Override
    public boolean isTriggeredAbility() {
        return this.abilityType.isTriggeredAbility();
    }

    @Override
    public boolean isNonManaActivatedAbility() {
        return this.abilityType.isNonManaActivatedAbility();
    }

    @Override
    public boolean isManaActivatedAbility() {
        return this.abilityType.isManaActivatedAbility();
    }

    @Override
    public boolean isManaAbility() {
        return this.abilityType.isManaAbility();
    }

    @Override
    public boolean resolve(Game game) {
        boolean result = true;
        if (this.checkIfClause(game)) {
            game.fireEvent(new GameEvent(GameEvent.EventType.RESOLVING_ABILITY, this.getOriginalId(), this, this.getControllerId()));
            if (this instanceof TriggeredAbility) {
                for (UUID modeId : this.getModes().getSelectedModes()) {
                    this.getModes().setActiveMode(modeId);
                    result = this.resolveMode(game);
                }
            } else {
                result = this.resolveMode(game);
            }
        }
        return result;
    }

    private boolean resolveMode(Game game) {
        boolean result = true;
        for (Effect effect : this.getEffects()) {
            if (game.inCheckPlayableState() && !(effect instanceof ManaEffect)) continue;
            if (effect instanceof OneShotEffect) {
                boolean effectResult = effect.apply(game, this);
                result &= effectResult;
                if (logger.isDebugEnabled() && !this.isManaAbility() && !effectResult) {
                    MageObject mageObject;
                    if (this.getSourceId() != null && (mageObject = game.getObject(this.getSourceId())) != null) {
                        logger.debug((Object)("AbilityImpl.resolve: object: " + mageObject.getName()));
                    }
                    logger.debug((Object)("AbilityImpl.resolve: effect returned false -" + effect.getText(this.getModes().getMode())));
                }
            } else {
                game.addEffect((ContinuousEffect)effect, this);
            }
            game.processAction();
        }
        return result;
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        boolean isMainPartAbility;
        Player controller = game.getPlayer(this.getControllerId());
        if (controller == null) {
            return false;
        }
        game.applyEffects();
        MageObject sourceObject = this.getSourceObject(game);
        this.initSourceObjectZoneChangeCounter(game, false);
        this.setSourcePermanentTransformCount(game);
        if (noMana) {
            if (!this.getManaCostsToPay().getVariableCosts().isEmpty()) {
                int xValue = CardUtil.getSourceCostsTag(game, this, "X", 0);
                this.clearManaCostsToPay();
                VariableManaCost xCosts = new VariableManaCost(VariableCostType.ADDITIONAL);
                xCosts.setAmount(xValue, xValue, false);
                this.addManaCostsToPay(xCosts);
            } else {
                this.clearManaCostsToPay();
            }
        }
        boolean bl = isMainPartAbility = !CardUtil.isFusedPartAbility(this, game);
        if (isMainPartAbility && this.abilityType == AbilityType.SPELL) {
            game.getContinuousEffects().applySpliceEffects(this, game);
        }
        if (isMainPartAbility && !this.activateAlternateOrAdditionalCosts(sourceObject, allowedIdentifiers, noMana, controller, game)) {
            return false;
        }
        if (this.getAbilityType() == AbilityType.SPELL && this.getManaCostsToPay().isEmpty() && this.getCosts().isEmpty() && !noMana) {
            return false;
        }
        this.handleChooseCostTargets(game, controller);
        if (isMainPartAbility) {
            this.adjustX(game);
        }
        VariableManaCost variableManaCost = this.handleManaXCosts(game, noMana, controller);
        String announceString = this.handleOtherXCosts(game, controller);
        AbilityImpl.handlePhyrexianCosts(game, this, this, this.getManaCostsToPay());
        this.handleChooseCostTargets(game, controller);
        if (!this.getModes().choose(game, this)) {
            return false;
        }
        for (UUID modeId : this.getModes().getSelectedModes()) {
            Cost cost = this.getModes().get(modeId).getCost();
            if (cost instanceof ManaCost) {
                this.addManaCostsToPay((ManaCost)cost.copy());
                continue;
            }
            if (cost == null) continue;
            this.costs.add(cost.copy());
        }
        if (controller.isTestMode() && !controller.addTargets(this, game)) {
            return false;
        }
        for (UUID modeId : this.getModes().getSelectedModes()) {
            boolean canCancel;
            this.getModes().setActiveMode(modeId);
            if (!this.getAbilityType().isTriggeredAbility()) {
                this.adjustTargets(game);
            }
            if (this.getTargets().isEmpty()) continue;
            Outcome outcome = this.getEffects().getOutcome(this);
            boolean bl2 = canCancel = this instanceof ActivatedAbility && controller.isHuman();
            if (this.getTargets().chooseTargets(outcome, this.controllerId, this, noMana, game, canCancel)) continue;
            return false;
        }
        if (this.getAbilityType() == AbilityType.SPELL) {
            GameEvent castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL_LATE, this.getId(), this, this.getControllerId());
            castEvent.setZone(game.getState().getZone(CardUtil.getMainCardId(game, this.sourceId)));
            if (game.replaceEvent(castEvent, this)) {
                return false;
            }
        }
        if (this instanceof ActivatedManaAbilityImpl && !this.getCosts().pay(this, game, this, this.controllerId, noMana, null)) {
            logger.debug((Object)"activate mana ability failed - non mana costs");
            return false;
        }
        if (isMainPartAbility) {
            game.getContinuousEffects().costModification(this, game);
        }
        UUID activatorId = this.controllerId;
        if (this instanceof ActivatedAbilityImpl && ((ActivatedAbilityImpl)this).getActivatorId() != null) {
            activatorId = ((ActivatedAbilityImpl)this).getActivatorId();
        }
        if (!this.getManaCostsToPay().pay(this, game, this, activatorId, false, null)) {
            return false;
        }
        if (!this.getCosts().pay(this, game, this, activatorId, noMana, null)) {
            logger.debug((Object)"activate failed - non mana costs");
            return false;
        }
        if (announceString != null && !announceString.equals("")) {
            game.informPlayers(announceString);
        }
        if (variableManaCost != null) {
            int xValue = CardUtil.getSourceCostsTag(game, this, "X", 0);
            game.informPlayers(controller.getLogName() + " announces a value of " + xValue + " for " + variableManaCost.getText() + CardUtil.getSourceLogName(game, this));
        }
        this.activated = true;
        return true;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public boolean activateAlternateOrAdditionalCosts(MageObject sourceObject, Set<MageIdentifier> allowedIdentifiers, boolean noMana, Player controller, Game game) {
        Player player;
        if (!this.getAbilityType().isActivatedAbility() && !this.getAbilityType().isPlayCardAbility()) {
            return true;
        }
        boolean canUseAlternativeCost = true;
        boolean canUseAdditionalCost = true;
        if (this instanceof SpellAbility) {
            switch (((SpellAbility)this).getSpellAbilityCastMode()) {
                case FLASHBACK: 
                case HARMONIZE: 
                case MADNESS: 
                case TRANSFORMED: 
                case DISTURB: 
                case MORE_THAN_MEETS_THE_EYE: 
                case BESTOW: 
                case MORPH: 
                case DISGUISE: 
                case PLOT: {
                    canUseAlternativeCost = false;
                    canUseAdditionalCost = true;
                    break;
                }
                case PROTOTYPE: 
                case NORMAL: {
                    canUseAlternativeCost = true;
                    canUseAdditionalCost = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ability cast mode: " + (Object)((Object)((SpellAbility)this).getSpellAbilityCastMode()));
                }
            }
        }
        if (this.getAbilityType() == AbilityType.SPELL && this instanceof SpellAbility && ((SpellAbility)this).getSpellAbilityType() == SpellAbilityType.BASE_ALTERNATE) {
            canUseAlternativeCost = false;
        }
        if (sourceObject == null || sourceObject instanceof Permanent) {
            return true;
        }
        Abilities<Ability> abilities = CardUtil.getAbilities(sourceObject, game);
        ArrayList<AlternativeSourceCosts> possibleAlternatives = new ArrayList<AlternativeSourceCosts>();
        for (Ability ability : abilities) {
            AlternativeSourceCosts alternativeSpellCosts;
            if (!canUseAlternativeCost || noMana || !(ability instanceof AlternativeSourceCosts) || !(alternativeSpellCosts = (AlternativeSourceCosts)ability).isAvailable(this, game) || !alternativeSpellCosts.canActivateAlternativeCostsNow(this, game) || !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)ability.getIdentifier())) continue;
            possibleAlternatives.add(alternativeSpellCosts);
        }
        if (canUseAlternativeCost && !noMana) {
            for (AlternativeSourceCosts alternativeSourceCosts : controller.getAlternativeSourceCosts()) {
                if (!alternativeSourceCosts.isAvailable(this, game) || !alternativeSourceCosts.canActivateAlternativeCostsNow(this, game) || !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)alternativeSourceCosts.getIdentifier())) continue;
                possibleAlternatives.add(alternativeSourceCosts);
            }
        }
        if ((player = game.getPlayer(this.getControllerId())) == null) {
            return false;
        }
        ChoiceImpl choice = new ChoiceImpl(false);
        choice.setSubMessage("for casting " + CardUtil.getSourceLogName(game, "", this, "", ""));
        AlternativeSourceCosts alternativeChosen = null;
        if (!possibleAlternatives.isEmpty()) {
            int choiceNumber;
            String key;
            int i;
            boolean mustChooseAlternative = !allowedIdentifiers.contains((Object)MageIdentifier.Default) && !allowedIdentifiers.contains((Object)this.getIdentifier());
            choice.setMessage(mustChooseAlternative ? "Choose an alternative cost" : "You may choose an alternative cost");
            LinkedHashMap<String, Integer> sort = new LinkedHashMap<String, Integer>();
            for (i = 0; i < possibleAlternatives.size(); ++i) {
                key = Integer.toString(i + 1);
                sort.put(key, i);
                AlternativeSourceCosts alternative = (AlternativeSourceCosts)possibleAlternatives.get(i);
                MageObject object = alternative.getSourceObject(game);
                choice.withItem(key, ((AlternativeSourceCosts)possibleAlternatives.get(i)).getAlternativeCostText(this, game), i, object != null ? ChoiceHintType.GAME_OBJECT : null, object != null ? object.getId().toString() : null);
            }
            if (!mustChooseAlternative) {
                key = Integer.toString(i + 1);
                sort.put(key, i);
                choice.withItem(key, "Cast with no alternative cost: " + this.getManaCosts().getText(), i, ChoiceHintType.GAME_OBJECT, sourceObject.getId().toString());
            }
            if (!player.choose(Outcome.Benefit, choice, game)) {
                return false;
            }
            String choiceKey = choice.getChoiceKey();
            if (sort.containsKey(choiceKey) && (choiceNumber = ((Integer)sort.get(choiceKey)).intValue()) < possibleAlternatives.size()) {
                alternativeChosen = (AlternativeSourceCosts)possibleAlternatives.get(choiceNumber);
            }
        }
        if (alternativeChosen != null) {
            alternativeChosen.activateAlternativeCosts(this, game);
        }
        for (Ability ability : abilities) {
            if (!canUseAdditionalCost || !(ability instanceof OptionalAdditionalSourceCosts)) continue;
            ((OptionalAdditionalSourceCosts)((Object)ability)).addOptionalAdditionalCosts(this, game);
        }
        return true;
    }

    protected String handleOtherXCosts(Game game, Player controller) {
        StringBuilder announceString = new StringBuilder();
        for (VariableCost variableCost : this.getCosts().getVariableCosts()) {
            if (variableCost instanceof VariableManaCost || ((Cost)((Object)variableCost)).isPaid()) continue;
            int xValue = variableCost.announceXValue(this, game);
            Cost fixedCost = variableCost.getFixedCostsFromAnnouncedValue(xValue);
            this.addCost(fixedCost);
            variableCost.setAmount(xValue, xValue, false);
            ((Cost)((Object)variableCost)).setPaid();
            String message = controller.getLogName() + " announces a value of " + xValue + " (" + variableCost.getActionText() + ')' + CardUtil.getSourceLogName(game, this);
            announceString.append(message);
            this.setCostsTag("X", xValue);
        }
        return announceString.toString();
    }

    public static void handlePhyrexianCosts(Game game, Ability source, Ability abilityToPay, ManaCosts manaCostsToPay) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return;
        }
        Iterator costIterator = manaCostsToPay.iterator();
        while (costIterator.hasNext()) {
            PayLifeCost payLifeCost;
            ManaCost cost = (ManaCost)costIterator.next();
            if (!cost.isPhyrexian() || !(payLifeCost = new PayLifeCost(2)).canPay(abilityToPay, source, controller.getId(), game) || !controller.chooseUse(Outcome.LoseLife, "Pay 2 life instead of " + cost.getText().replace("/P", "") + " (phyrexian cost)?", source, game)) continue;
            costIterator.remove();
            abilityToPay.addCost(payLifeCost);
            manaCostsToPay.incrPhyrexianPaid();
        }
    }

    public static void handlePhyrexianLikeEffects(Game game, Ability source, Ability abilityToPay, ManaCosts manaCostsToPay) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return;
        }
        FilterMana phyrexianColors = controller.getPhyrexianColors();
        if (controller.getPhyrexianColors() == null) {
            return;
        }
        Iterator costIterator = manaCostsToPay.iterator();
        while (costIterator.hasNext()) {
            PayLifeCost payLifeCost;
            ManaCost cost = (ManaCost)costIterator.next();
            Mana mana = cost.getMana();
            if (!(phyrexianColors.isWhite() && mana.getWhite() > 0 || phyrexianColors.isBlue() && mana.getBlue() > 0 || phyrexianColors.isBlack() && mana.getBlack() > 0 || phyrexianColors.isRed() && mana.getRed() > 0) && (!phyrexianColors.isGreen() || mana.getGreen() <= 0) || !(payLifeCost = new PayLifeCost(2)).canPay(abilityToPay, source, controller.getId(), game) || !controller.chooseUse(Outcome.LoseLife, "Pay 2 life instead of " + cost.getText().replace("/P", "") + " (pay life cost)?", source, game) || !payLifeCost.pay(abilityToPay, game, source, controller.getId(), false, null)) continue;
            costIterator.remove();
            abilityToPay.addCost(payLifeCost);
        }
    }

    private void handleChooseCostTargets(Game game, Player controller) {
        for (Cost cost : this.getCosts()) {
            if (!(cost instanceof EarlyTargetCost) || !cost.getTargets().isEmpty()) continue;
            ((EarlyTargetCost)((Object)cost)).chooseTarget(game, this, controller);
        }
        for (ManaCost manaCost : this.getManaCostsToPay()) {
            if (!(manaCost instanceof EarlyTargetCost) || !manaCost.getTargets().isEmpty()) continue;
            ((EarlyTargetCost)((Object)manaCost)).chooseTarget(game, this, controller);
        }
    }

    protected VariableManaCost handleManaXCosts(Game game, boolean noMana, Player controller) {
        VariableManaCost variableManaCost = null;
        for (ManaCost cost : this.getManaCostsToPay()) {
            if (!(cost instanceof VariableManaCost)) continue;
            if (variableManaCost == null) {
                variableManaCost = (VariableManaCost)cost;
                continue;
            }
            logger.error((Object)("Variable mana cost allowes only in one instance per ability: " + this));
        }
        if (variableManaCost != null && !variableManaCost.isPaid()) {
            if (!noMana || variableManaCost.getCostType().canUseAnnounceOnFreeCast()) {
                int xValue = variableManaCost.wasAnnounced() ? variableManaCost.getAmount() : controller.announceX(variableManaCost.getMinX(), variableManaCost.getMaxX(), "Announce the value for " + variableManaCost.getText(), game, this, true);
                int amountMana = xValue * variableManaCost.getXInstancesCount();
                StringBuilder manaString = threadLocalBuilder.get();
                if (variableManaCost.getFilter() == null || variableManaCost.getFilter().isGeneric()) {
                    manaString.append('{').append(amountMana).append('}');
                } else {
                    String manaSymbol = null;
                    if (variableManaCost.getFilter().isBlack()) {
                        manaSymbol = variableManaCost.getFilter().isRed() ? "B/R" : "B";
                    } else if (variableManaCost.getFilter().isRed()) {
                        manaSymbol = "R";
                    } else if (variableManaCost.getFilter().isBlue()) {
                        manaSymbol = "U";
                    } else if (variableManaCost.getFilter().isGreen()) {
                        manaSymbol = "G";
                    } else if (variableManaCost.getFilter().isWhite()) {
                        manaSymbol = "W";
                    }
                    if (manaSymbol == null) {
                        throw new UnsupportedOperationException("ManaFilter is not supported: " + this);
                    }
                    for (int i = 0; i < amountMana; ++i) {
                        manaString.append('{').append(manaSymbol).append('}');
                    }
                }
                this.addManaCostsToPay(new ManaCostsImpl(manaString.toString()));
                this.getManaCostsToPay().setX(xValue, amountMana);
                this.setCostsTag("X", xValue);
            }
            variableManaCost.setPaid();
        }
        return variableManaCost;
    }

    @Override
    public void reset(Game game) {
    }

    @Override
    public boolean checkIfClause(Game game) {
        return true;
    }

    @Override
    public UUID getControllerId() {
        return this.controllerId;
    }

    @Override
    public UUID getControllerOrOwnerId() {
        return this.getControllerId();
    }

    @Override
    public void setControllerId(UUID controllerId) {
        this.controllerId = controllerId;
        for (Watcher watcher : this.getWatchers()) {
            watcher.setControllerId(controllerId);
        }
        if (this.subAbilities != null) {
            for (Ability subAbility : this.subAbilities) {
                subAbility.setControllerId(controllerId);
            }
        }
    }

    @Override
    public UUID getSourceId() {
        return this.sourceId;
    }

    @Override
    public void setSourceId(UUID sourceId) {
        if (this.sourceId == null) {
            this.sourceId = sourceId;
        } else if (!(this instanceof MageSingleton)) {
            this.sourceId = sourceId;
        }
        if (this.subAbilities != null) {
            for (Ability subAbility : this.subAbilities) {
                subAbility.setSourceId(sourceId);
            }
        }
        for (Watcher watcher : this.getWatchers()) {
            watcher.setSourceId(sourceId);
        }
    }

    @Override
    public Costs<Cost> getCosts() {
        return this.costs;
    }

    @Override
    public ManaCosts<ManaCost> getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public ManaCosts<ManaCost> getManaCostsToPay() {
        return this.manaCostsToPay;
    }

    @Override
    public Map<String, Object> getCostsTagMap() {
        return this.costsTagMap;
    }

    @Override
    public void setCostsTag(String tag, Object value) {
        if (this.costsTagMap == null) {
            this.costsTagMap = new HashMap<String, Object>();
        }
        this.costsTagMap.put(tag, value);
    }

    @Override
    public Effects getEffects() {
        return this.getModes().getMode().getEffects();
    }

    @Override
    public Effects getAllEffects() {
        Effects allEffects = new Effects(new Effect[0]);
        for (Mode mode : this.getModes().values()) {
            allEffects.addAll(mode.getEffects());
        }
        return allEffects;
    }

    @Override
    public Effects getEffects(Game game, EffectType effectType) {
        Effects typedEffects = new Effects(new Effect[0]);
        for (Effect effect : this.getEffects()) {
            if (effect.getEffectType() != effectType) continue;
            typedEffects.add(effect);
        }
        return typedEffects;
    }

    @Override
    public Zone getZone() {
        return this.zone;
    }

    @Override
    public List<Watcher> getWatchers() {
        return this.watchers;
    }

    @Override
    public void addWatcher(Watcher watcher) {
        watcher.setSourceId(this.sourceId);
        watcher.setControllerId(this.controllerId);
        this.getWatchers().add(watcher);
    }

    @Override
    public List<Ability> getSubAbilities() {
        if (this.subAbilities != null) {
            return this.subAbilities;
        }
        return emptyAbilities;
    }

    @Override
    public void addSubAbility(Ability ability) {
        if (this.subAbilities == null) {
            this.subAbilities = new ArrayList<Ability>();
        }
        ability.setSourceId(this.sourceId);
        ability.setControllerId(this.controllerId);
        this.subAbilities.add(ability);
    }

    @Override
    public boolean isUsesStack() {
        return this.usesStack;
    }

    public void appendToRule(String appendToRule) {
        this.appendToRule = appendToRule;
    }

    @Override
    public String getRule() {
        return this.getRule(false);
    }

    @Override
    public String getRule(boolean all) {
        StringBuilder sbRule = threadLocalBuilder.get();
        if (all || this.abilityType != AbilityType.SPELL) {
            if (!this.getManaCosts().isEmpty()) {
                sbRule.append(this.getManaCosts().getText());
            }
            if (!this.getCosts().isEmpty()) {
                if (sbRule.length() > 0) {
                    sbRule.append(", ");
                }
                sbRule.append(this.getCosts().getText());
            }
            if (sbRule.length() > 0) {
                sbRule.append(": ");
            }
        }
        String ruleStart = sbRule.toString();
        String text = this.getModes().getText();
        StringBuilder rule = new StringBuilder();
        if (!text.isEmpty()) {
            if (ruleStart.length() > 1) {
                String end = ruleStart.substring(ruleStart.length() - 2).trim();
                if (end.isEmpty() || end.equals(":") || end.equals(".")) {
                    rule.append(ruleStart + CardUtil.getTextWithFirstCharUpperCase(text));
                } else {
                    rule.append(ruleStart + text);
                }
            } else {
                rule.append(ruleStart + text);
            }
        } else {
            rule.append(ruleStart);
        }
        if (this.appendToRule != null) {
            rule.append(this.appendToRule);
        }
        if (this instanceof TriggeredAbility || this instanceof EntersBattlefieldAbility) {
            return rule.toString();
        }
        return this.addRulePrefix(rule.toString());
    }

    @Override
    public String getRule(String source) {
        return this.formatRule(this.getRule(), source);
    }

    protected String formatRule(String rule, String source) {
        String replace = rule;
        if (rule != null && source != null && !source.isEmpty()) {
            replace = rule.replace("{this}", source);
        }
        return replace;
    }

    @Override
    public void addCost(Cost cost) {
        if (cost == null) {
            return;
        }
        if (cost instanceof Costs) {
            Costs list = (Costs)cost;
            for (Cost single : list) {
                this.addCost(single);
            }
        } else if (cost instanceof ManaCost) {
            this.manaCosts.add((ManaCost)cost);
            this.manaCostsToPay.add((ManaCost)cost);
        } else {
            this.costs.add(cost);
        }
    }

    @Override
    public void addManaCostsToPay(ManaCost manaCost) {
        if (manaCost == null) {
            return;
        }
        if (manaCost instanceof ManaCosts) {
            this.manaCostsToPay.addAll((ManaCosts)manaCost);
        } else {
            this.manaCostsToPay.add(manaCost);
        }
    }

    @Override
    public void setVariableCostsMinMax(int min, int max) {
        MinMaxVariableCost minMaxCost;
        for (ManaCost cost : this.getManaCosts()) {
            if (!(cost instanceof MinMaxVariableCost)) continue;
            minMaxCost = (MinMaxVariableCost)((Object)cost);
            minMaxCost.setMinX(min);
            minMaxCost.setMaxX(max);
        }
        for (ManaCost cost : this.getManaCostsToPay()) {
            if (!(cost instanceof MinMaxVariableCost)) continue;
            minMaxCost = (MinMaxVariableCost)((Object)cost);
            minMaxCost.setMinX(min);
            minMaxCost.setMaxX(max);
        }
    }

    @Override
    public void setVariableCostsValue(int xValue) {
        boolean foundBaseCost = false;
        for (ManaCost cost : this.getManaCosts()) {
            if (!(cost instanceof VariableManaCost)) continue;
            foundBaseCost = true;
            ((VariableManaCost)cost).setMinX(xValue);
            ((VariableManaCost)cost).setMaxX(xValue);
            ((VariableManaCost)cost).setAmount(xValue, xValue, false);
        }
        boolean foundPreparedCost = false;
        for (ManaCost cost : this.getManaCostsToPay()) {
            if (!(cost instanceof VariableManaCost)) continue;
            foundPreparedCost = true;
            ((VariableManaCost)cost).setMinX(xValue);
            ((VariableManaCost)cost).setMaxX(xValue);
            ((VariableManaCost)cost).setAmount(xValue, xValue, false);
        }
        if (!foundPreparedCost || !foundBaseCost) {
            throw new IllegalArgumentException("Wrong code usage: auto-announced X values allowed in mana costs only");
        }
    }

    @Override
    public void addEffect(Effect effect) {
        if (effect != null) {
            this.getEffects().add(effect);
        }
    }

    @Override
    public void addTarget(Target target) {
        if (target instanceof TargetCardInLibrary || target instanceof TargetCard && target.getZone().equals((Object)Zone.LIBRARY)) {
            throw new IllegalArgumentException("Wrong usage of TargetCardInLibrary - you must use it with SearchLibrary only");
        }
        if (target != null) {
            this.getTargets().add(target);
        }
    }

    @Override
    public Targets getTargets() {
        if (this.getModes().getMode() != null) {
            return this.getModes().getMode().getTargets();
        }
        return new Targets().withReadOnly();
    }

    @Override
    public Targets getAllSelectedTargets() {
        Targets res = new Targets();
        for (UUID modeId : this.getModes().getSelectedModes()) {
            Mode mode = this.getModes().get(modeId);
            if (mode == null) continue;
            res.addAll(mode.getTargets());
        }
        return res.withReadOnly();
    }

    @Override
    public UUID getFirstTarget() {
        return this.getTargets().getFirstTarget();
    }

    @Override
    public boolean isModal() {
        return this.getModes().size() > 1;
    }

    @Override
    public void addMode(Mode mode) {
        this.getModes().addMode(mode);
        int currentMin = this.getModes().getMinModes();
        int currentMax = this.getModes().getMaxModes(null, null);
        boolean isFine = true;
        if (currentMin < 0 || currentMax < 0) {
            isFine = false;
        }
        if (currentMin > 0 && currentMin > currentMax) {
            isFine = false;
        }
        if (!isFine) {
            throw new IllegalArgumentException(String.format("Wrong code usage: you must setup correct min and max modes (%d, %d) for %s", currentMin, currentMax, this));
        }
    }

    @Override
    public Modes getModes() {
        return this.modes;
    }

    @Override
    public boolean canChooseTarget(Game game, UUID playerId) {
        return AbilityImpl.canChooseTargetAbility(this, this.getModes(), game, playerId);
    }

    protected static boolean canChooseTargetAbility(Ability ability, Modes modes, Game game, UUID controllerId) {
        int found = 0;
        for (Mode mode : modes.values()) {
            boolean validTargets = true;
            for (Target target : mode.getTargets()) {
                UUID abilityControllerId;
                if (target.canChooseOrAlreadyChosen(abilityControllerId = target.getAffectedAbilityControllerId(controllerId), ability, game)) continue;
                validTargets = false;
                break;
            }
            if (!validTargets) continue;
            ++found;
            if (modes.isMayChooseSameModeMoreThanOnce()) {
                return true;
            }
            if (found < modes.getMinModes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        if (!this.hasSourceObjectAbility(game, sourceObject, event)) {
            return false;
        }
        UUID affectedSourceId = AbilityImpl.getRealSourceObjectId(this, sourceObject);
        MageObject affectedSourceObject = game.getObject(affectedSourceId);
        if (affectedSourceId == null) {
            return true;
        }
        if (this.zone == Zone.COMMAND && (affectedSourceObject instanceof Emblem || affectedSourceObject instanceof Dungeon || affectedSourceObject instanceof Plane)) {
            return true;
        }
        if (game.getPermanentEntering(affectedSourceId) != null && this.zone == Zone.BATTLEFIELD) {
            return true;
        }
        Zone affectedObjectZone = game.getState().getZone(affectedSourceId);
        if (event != null && AbilityImpl.isAbilityCanLookBackInTime(this) && AbilityImpl.isEventCanLookBackInTime(event)) {
            if (game.checkShortLivingLKI(affectedSourceId, Zone.BATTLEFIELD)) {
                affectedObjectZone = Zone.BATTLEFIELD;
            }
            if (game.checkShortLivingLKI(affectedSourceId, Zone.GRAVEYARD)) {
                affectedObjectZone = Zone.GRAVEYARD;
            }
        }
        return this.zone.match(affectedObjectZone);
    }

    public static boolean isAbilityCanLookBackInTime(Ability ability) {
        if (ability instanceof StaticAbility) {
            return true;
        }
        if (ability instanceof TriggeredAbility) {
            return ((TriggeredAbility)ability).isLeavesTheBattlefieldTrigger();
        }
        return false;
    }

    public static boolean isEventCanLookBackInTime(GameEvent event) {
        if (event == null) {
            return false;
        }
        ArrayList<Object> allEvents = new ArrayList<Object>();
        if (event instanceof BatchEvent) {
            allEvents.addAll(((BatchEvent)event).getEvents());
        } else {
            allEvents.add(event);
        }
        return allEvents.stream().anyMatch(e -> {
            switch (e.getType()) {
                case DESTROYED_PERMANENT: 
                case EXPLOITED_CREATURE: 
                case SACRIFICED_PERMANENT: {
                    return true;
                }
                case ZONE_CHANGE: {
                    return ((ZoneChangeEvent)e).getFromZone() == Zone.BATTLEFIELD;
                }
            }
            return false;
        });
    }

    protected static UUID getRealSourceObjectId(Ability sourceAbility, MageObject sourceObject) {
        if (sourceAbility instanceof MageSingleton && sourceObject != null) {
            return sourceObject.getId();
        }
        return sourceAbility.getSourceId();
    }

    @Override
    public final boolean hasSourceObjectAbility(Game game, MageObject sourceObject, GameEvent event) {
        MageObject object = sourceObject;
        if (object == null && (object = game.getPermanentEntering(this.getSourceId())) == null) {
            object = game.getObject(this.getSourceId());
        }
        if (object == null) {
            return true;
        }
        if (!object.hasAbility(this, game)) {
            return false;
        }
        if (object instanceof Permanent) {
            return ((Permanent)object).isPhasedIn() || this.getWorksPhasedOut();
        }
        return true;
    }

    public String toString() {
        return this.getRule();
    }

    @Override
    public boolean getRuleAtTheTop() {
        return this.ruleAtTheTop;
    }

    @Override
    public Ability setRuleAtTheTop(boolean ruleAtTheTop) {
        if (!(this instanceof MageSingleton)) {
            this.ruleAtTheTop = ruleAtTheTop;
        }
        return this;
    }

    @Override
    public boolean getRuleVisible() {
        return this.ruleVisible;
    }

    @Override
    public Ability setRuleVisible(boolean ruleVisible) {
        if (!(this instanceof MageSingleton)) {
            this.ruleVisible = ruleVisible;
        }
        return this;
    }

    @Override
    public boolean getAdditionalCostsRuleVisible() {
        return this.ruleAdditionalCostsVisible;
    }

    @Override
    public void setAdditionalCostsRuleVisible(boolean ruleAdditionalCostsVisible) {
        this.ruleAdditionalCostsVisible = ruleAdditionalCostsVisible;
    }

    @Override
    public UUID getOriginalId() {
        return this.originalId;
    }

    @Override
    public Ability setAbilityWord(AbilityWord abilityWord) {
        this.abilityWord = abilityWord;
        return this;
    }

    @Override
    public Ability withFlavorWord(String flavorWord) {
        this.flavorWord = flavorWord;
        return this;
    }

    @Override
    public String addRulePrefix(String rule) {
        if (this.abilityWord != null) {
            return this.abilityWord.formatWord() + CardUtil.getTextWithFirstCharUpperCase(rule);
        }
        if (this.flavorWord != null) {
            return CardUtil.italicizeWithEmDash(this.flavorWord) + CardUtil.getTextWithFirstCharUpperCase(rule);
        }
        return rule;
    }

    @Override
    public Ability withFirstModeFlavorWord(String flavorWord) {
        this.modes.getMode().withFlavorWord(flavorWord);
        return this;
    }

    @Override
    public Ability withFirstModeCost(Cost cost) {
        this.modes.getMode().withCost(cost);
        return this;
    }

    @Override
    public String getGameLogMessage(Game game) {
        if (game.isSimulation()) {
            return "";
        }
        MageObject object = game.getObject(this.sourceId);
        if (object == null) {
            logger.warn((Object)("Could get no object: " + this));
        }
        return " activates: " + (object != null ? this.formatRule(this.getModes().getText(), object.getLogName()) : this.getModes().getText()) + " from " + this.getMessageText(game);
    }

    protected String getMessageText(Game game) {
        Spell spell;
        StringBuilder sb = threadLocalBuilder.get();
        MageObject object = game.getObject(this.sourceId);
        if (object != null) {
            if (object instanceof StackAbility) {
                Card card = game.getCard(((StackAbility)object).getSourceId());
                if (card != null) {
                    sb.append(GameLog.getColoredObjectIdName(card));
                } else {
                    sb.append(GameLog.getColoredObjectIdName(object));
                }
            } else if (object instanceof Spell) {
                spell = (Spell)object;
                String castText = spell.getSpellCastText(game);
                sb.append(castText.startsWith("Cast ") ? castText.substring(5) : castText);
                if (spell.getFromZone() == Zone.GRAVEYARD) {
                    sb.append(" from graveyard");
                }
                sb.append(this.getOptionalTextSuffix(game, spell));
            } else {
                sb.append(GameLog.getColoredObjectIdName(object));
            }
        } else {
            sb.append("unknown");
        }
        if (object instanceof Spell && ((Spell)object).getSpellAbilities().size() > 1) {
            if (((Spell)object).getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
                spell = (Spell)object;
                int i = 0;
                for (SpellAbility spellAbility : spell.getSpellAbilities()) {
                    String half = ++i == 1 ? " left" : " right";
                    if (spellAbility.getTargets().isEmpty()) continue;
                    sb.append(half).append(" half targeting ");
                    for (Target target : spellAbility.getTargets()) {
                        sb.append(target.getTargetedName(game));
                    }
                }
            } else {
                spell = (Spell)object;
                int i = 0;
                for (SpellAbility spellAbility : spell.getSpellAbilities()) {
                    if (++i > 1) {
                        sb.append(" splicing ");
                        if (spellAbility.name.length() > 5 && spellAbility.name.startsWith("Cast ")) {
                            sb.append(spellAbility.name.substring(5));
                        } else {
                            sb.append(spellAbility.name);
                        }
                    }
                    sb.append(this.getTargetDescriptionForLog(spellAbility.getTargets(), game));
                }
            }
        } else if (object instanceof Spell && ((Spell)object).getSpellAbility().getModes().size() > 1) {
            Modes spellModes = ((Spell)object).getSpellAbility().getModes();
            block3: for (UUID selectedModeId : spellModes.getSelectedModes()) {
                Mode selectedMode = spellModes.get(selectedModeId);
                int item = 0;
                for (Mode mode : spellModes.values()) {
                    ++item;
                    if (!mode.getId().equals(selectedMode.getId())) continue;
                    sb.append(" (mode ").append(item).append(')');
                    sb.append(this.getTargetDescriptionForLog(selectedMode.getTargets(), game));
                    continue block3;
                }
            }
        } else {
            sb.append(this.getTargetDescriptionForLog(this.getTargets(), game));
        }
        return sb.toString();
    }

    @Override
    public String getTargetDescription(Targets targets, Game game) {
        return this.getTargetDescriptionForLog(targets, game);
    }

    protected String getTargetDescriptionForLog(Targets targets, Game game) {
        StringBuilder sb = new StringBuilder();
        if (!targets.isEmpty()) {
            String usedVerb = null;
            boolean isFirstTarget = true;
            for (Target target : targets) {
                String targetHintInfo;
                if (target.getTargets().isEmpty()) continue;
                String string = targetHintInfo = target.getChooseHint() == null ? "" : " (" + target.getChooseHint() + ")";
                if (!target.isNotTarget()) {
                    if (usedVerb == null || usedVerb.equals(" choosing ")) {
                        usedVerb = " targeting ";
                        sb.append(usedVerb);
                    }
                } else if (target.isNotTarget() && (usedVerb == null || usedVerb.equals(" targeting "))) {
                    usedVerb = " choosing ";
                    sb.append(usedVerb);
                }
                if (!isFirstTarget) {
                    sb.append(", ");
                }
                isFirstTarget = false;
                sb.append(target.getTargetedName(game));
                sb.append(targetHintInfo);
            }
        }
        return sb.toString();
    }

    private String getOptionalTextSuffix(Game game, Spell spell) {
        StringBuilder sb = new StringBuilder();
        for (Ability ability : spell.getAbilities()) {
            if (ability instanceof OptionalAdditionalSourceCosts) {
                sb.append(((OptionalAdditionalSourceCosts)((Object)ability)).getCastMessageSuffix());
            }
            if (!(ability instanceof AlternativeSourceCosts) || !((AlternativeSourceCosts)ability).isActivated(this, game)) continue;
            sb.append(((AlternativeSourceCosts)ability).getCastMessageSuffix(game));
        }
        return sb.toString();
    }

    @Override
    public boolean getWorksFaceDown() {
        return this.worksFaceDown;
    }

    @Override
    public void setWorksFaceDown(boolean worksFaceDown) {
        this.worksFaceDown = worksFaceDown;
    }

    @Override
    public boolean getWorksPhasedOut() {
        return this.worksPhasedOut;
    }

    @Override
    public void setWorksPhasedOut(boolean worksPhasedOut) {
        this.worksPhasedOut = worksPhasedOut;
    }

    @Override
    public MageObject getSourceObject(Game game) {
        return game.getObject(this.getSourceId());
    }

    @Override
    public MageObject getSourceObjectIfItStillExists(Game game) {
        if (this.getStackMomentSourceZCC() == 0 || this.getStackMomentSourceZCC() == this.getCurrentSourceObjectZoneChangeCounter(game)) {
            return game.getObject(this.getSourceId());
        }
        return null;
    }

    @Override
    public Card getSourceCardIfItStillExists(Game game) {
        MageObject mageObject = this.getSourceObjectIfItStillExists(game);
        if (mageObject instanceof Card) {
            return (Card)mageObject;
        }
        return null;
    }

    @Override
    public Permanent getSourcePermanentIfItStillExists(Game game) {
        MageObject mageObject = this.getSourceObjectIfItStillExists(game);
        if (mageObject instanceof Permanent) {
            return (Permanent)mageObject;
        }
        return null;
    }

    @Override
    public Permanent getSourcePermanentOrLKI(Game game) {
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            permanent = (Permanent)game.getLastKnownInformation(this.getSourceId(), Zone.BATTLEFIELD, this.getStackMomentSourceZCC());
        }
        return permanent;
    }

    @Override
    public void setSourceObjectZoneChangeCounter(int sourceObjectZoneChangeCounter) {
        this.sourceObjectZoneChangeCounter = sourceObjectZoneChangeCounter;
    }

    @Override
    public void initSourceObjectZoneChangeCounter(Game game, boolean force) {
        if (!(this instanceof MageSingleton) && (force || this.sourceObjectZoneChangeCounter == 0)) {
            this.setSourceObjectZoneChangeCounter(this.getCurrentSourceObjectZoneChangeCounter(game));
        }
    }

    private int getCurrentSourceObjectZoneChangeCounter(Game game) {
        int zcc = game.getState().getZoneChangeCounter(this.getSourceId());
        return zcc;
    }

    @Override
    public int getStackMomentSourceZCC() {
        return this.sourceObjectZoneChangeCounter;
    }

    @Override
    public void setSourcePermanentTransformCount(Game game) {
        Permanent permanent = this.getSourcePermanentOrLKI(game);
        if (permanent != null) {
            this.sourcePermanentTransformCount = permanent.getTransformCount();
        }
    }

    @Override
    public boolean checkTransformCount(Permanent permanent, Game game) {
        if (permanent == null || !permanent.getId().equals(this.sourceId) || permanent.getZoneChangeCounter(game) != this.sourceObjectZoneChangeCounter) {
            return true;
        }
        return permanent.getTransformCount() == this.sourcePermanentTransformCount;
    }

    @Override
    public boolean canFizzle() {
        return this.canFizzle;
    }

    @Override
    public void setCanFizzle(boolean canFizzle) {
        this.canFizzle = canFizzle;
    }

    @Override
    public boolean canBeCopied() {
        return this.canBeCopied;
    }

    @Override
    public Ability withCanBeCopied(boolean canBeCopied) {
        this.canBeCopied = canBeCopied;
        return this;
    }

    @Override
    public AbilityImpl setTargetAdjuster(TargetAdjuster targetAdjuster) {
        if (targetAdjuster == null) {
            this.targetAdjuster = null;
            return this;
        }
        if (targetAdjuster instanceof GenericTargetAdjuster && this.getTargets().isEmpty()) {
            throw new IllegalStateException("Target adjuster being added but no targets are set!");
        }
        this.targetAdjuster = targetAdjuster;
        this.targetAdjuster.addDefaultTargets(this);
        return this;
    }

    @Override
    public TargetAdjuster getTargetAdjuster() {
        return this.targetAdjuster;
    }

    @Override
    public void adjustTargets(Game game) {
        if (this.targetAdjuster != null) {
            this.targetAdjuster.adjustTargets(this, game);
        }
    }

    @Override
    public AbilityImpl setCostAdjuster(CostAdjuster costAdjuster) {
        this.costAdjuster = costAdjuster;
        return this;
    }

    @Override
    public CostAdjuster getCostAdjuster() {
        return this.costAdjuster;
    }

    @Override
    public void adjustX(Game game) {
        if (this.costAdjuster != null) {
            this.costAdjuster.prepareX(this, game);
        }
    }

    @Override
    public void adjustCostsPrepare(Game game) {
        if (this.costAdjuster != null) {
            this.costAdjuster.prepareCost(this, game);
        }
    }

    @Override
    public void adjustCostsModify(Game game, CostModificationType costModificationType) {
        if (this.costAdjuster != null) {
            this.costAdjuster.modifyCost(this, game, costModificationType);
        }
    }

    @Override
    public List<Hint> getHints() {
        return this.hints;
    }

    @Override
    public Ability addHint(Hint hint) {
        this.hints.add(hint);
        return this;
    }

    @Override
    public void setModeTag(String tag) {
        if (this.getModes().getMode() != null) {
            this.getModes().getMode().setModeTag(tag);
        }
    }

    @Override
    public final List<CardIcon> getIcons() {
        return this.getIcons(null);
    }

    @Override
    public List<CardIcon> getIcons(Game game) {
        return this.icons;
    }

    @Override
    public Ability addIcon(CardIcon cardIcon) {
        this.icons.add(cardIcon);
        return this;
    }

    @Override
    public Ability addCustomOutcome(Outcome customOutcome) {
        this.customOutcome = customOutcome;
        return this;
    }

    @Override
    public Outcome getCustomOutcome() {
        return this.customOutcome;
    }

    @Override
    public boolean isSameInstance(Ability ability) {
        if (ability == null) {
            return false;
        }
        return this == ability || this.getId().equals(ability.getId()) || this.getOriginalId().equals(ability.getOriginalId()) || this.getClass() == ability.getClass() && this.getRule(true).equals(ability.getRule(true));
    }

    @Override
    public MageIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public AbilityImpl setIdentifier(MageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public boolean caresAboutManaColor() {
        return this.getEffects().stream().filter(Objects::nonNull).map(Effect::getCondition).filter(Objects::nonNull).anyMatch(Condition::caresAboutManaColor);
    }

    public AbilityImpl copyWithZone(Zone zone) {
        if (this instanceof MageSingleton) {
            return this;
        }
        AbilityImpl copy = (AbilityImpl)this.copy();
        copy.zone = zone;
        copy.newId();
        return copy;
    }
}

