/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.MageObject;
import mage.abilities.AbilityImpl;
import mage.abilities.ActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.TargetController;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

public abstract class ActivatedAbilityImpl
extends AbilityImpl
implements ActivatedAbility {
    protected int maxActivationsPerTurn = Integer.MAX_VALUE;
    protected int maxActivationsPerGame = Integer.MAX_VALUE;
    protected Condition condition;
    protected TimingRule timing = TimingRule.INSTANT;
    protected TargetController mayActivate = TargetController.YOU;
    protected UUID activatorId;

    protected ActivatedAbilityImpl(AbilityType abilityType, Zone zone) {
        super(abilityType, zone);
    }

    protected ActivatedAbilityImpl(ActivatedAbilityImpl ability) {
        super(ability);
        this.timing = ability.timing;
        this.mayActivate = ability.mayActivate;
        this.activatorId = ability.activatorId;
        this.maxActivationsPerTurn = ability.maxActivationsPerTurn;
        this.maxActivationsPerGame = ability.maxActivationsPerGame;
        this.condition = ability.condition;
    }

    protected ActivatedAbilityImpl(Zone zone, Effect effect, Cost cost) {
        super(AbilityType.ACTIVATED_NONMANA, zone);
        this.addEffect(effect);
        this.addCost(cost);
    }

    @Override
    public abstract ActivatedAbilityImpl copy();

    protected boolean checkTargetController(UUID playerId, Game game) {
        switch (this.mayActivate) {
            case ANY: 
            case EACH_PLAYER: {
                return true;
            }
            case ACTIVE: {
                return game.getActivePlayerId() == playerId;
            }
            case NOT_YOU: {
                return !this.controlsAbility(playerId, game);
            }
            case TEAM: {
                return !game.getPlayer(this.controllerId).hasOpponent(playerId, game);
            }
            case OPPONENT: {
                return game.getPlayer(this.controllerId).hasOpponent(playerId, game);
            }
            case OWNER: {
                Permanent permanent = game.getPermanent(this.getSourceId());
                return permanent != null && permanent.isOwnedBy(playerId);
            }
            case YOU: {
                return this.controlsAbility(playerId, game);
            }
            case CONTROLLER_ATTACHED_TO: {
                Permanent enchantment = game.getPermanent(this.getSourceId());
                if (enchantment == null || enchantment.getAttachedTo() == null) {
                    return false;
                }
                Permanent enchanted = game.getPermanent(enchantment.getAttachedTo());
                return enchanted != null && enchanted.isControlledBy(playerId);
            }
        }
        return true;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        boolean asInstant;
        if (!this.hasMoreActivationsThisTurn(game) || this.condition != null && !this.condition.apply(game, this)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (!this.checkTargetController(playerId, game)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        Set<ApprovingObject> approvingObjects = game.getContinuousEffects().asThough(this.sourceId, AsThoughEffectType.ACTIVATE_AS_INSTANT, this, this.controllerId, game);
        boolean bl = asInstant = !approvingObjects.isEmpty() || this.timing == TimingRule.INSTANT;
        if (!asInstant && !game.canPlaySorcery(playerId)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (!this.getCosts().canPay(this, this, playerId, game) || !this.canChooseTarget(game, playerId)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (this.isActivatedAbility() && game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.ACTIVATE_ABILITY, this.getId(), this, playerId))) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        this.activatorId = playerId;
        if (approvingObjects.isEmpty()) {
            return ActivatedAbility.ActivationStatus.withoutApprovingObject(true);
        }
        return new ActivatedAbility.ActivationStatus(approvingObjects);
    }

    @Override
    public ManaOptions getMinimumCostToActivate(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        return this.getManaCostsToPay().getOptions(player.canPayLifeCost(this));
    }

    protected boolean controlsAbility(UUID playerId, Game game) {
        if (this.controllerId != null && this.controllerId.equals(playerId)) {
            return true;
        }
        MageObject mageObject = game.getObject(this.sourceId);
        if (mageObject instanceof CommandObject) {
            return ((CommandObject)mageObject).isControlledBy(playerId);
        }
        if (game.getState().getZone(this.sourceId) != Zone.BATTLEFIELD) {
            return ((Card)mageObject).isOwnedBy(playerId);
        }
        return false;
    }

    @Override
    public ActivatedAbilityImpl setMayActivate(TargetController mayActivate) {
        this.mayActivate = mayActivate;
        return this;
    }

    public UUID getActivatorId() {
        return this.activatorId;
    }

    public TimingRule getTiming() {
        return this.timing;
    }

    @Override
    public ActivatedAbilityImpl setTiming(TimingRule timing) {
        this.timing = timing;
        return this;
    }

    protected boolean hasMoreActivationsThisTurn(Game game) {
        if (this.getMaxActivationsPerTurn(game) == Integer.MAX_VALUE && this.maxActivationsPerGame == Integer.MAX_VALUE) {
            return true;
        }
        ActivationInfo activationInfo = this.getActivationInfo(game);
        if (activationInfo == null) {
            return true;
        }
        if (activationInfo.totalActivations >= this.maxActivationsPerGame) {
            return false;
        }
        return activationInfo.turnNum != game.getTurnNum() || activationInfo.activationCounter < this.getMaxActivationsPerTurn(game);
    }

    @Override
    public int getMaxMoreActivationsThisTurn(Game game) {
        if (this.getMaxActivationsPerTurn(game) == Integer.MAX_VALUE && this.maxActivationsPerGame == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        ActivationInfo activationInfo = this.getActivationInfo(game);
        if (activationInfo == null) {
            return Math.min(this.maxActivationsPerGame, this.getMaxActivationsPerTurn(game));
        }
        if (activationInfo.totalActivations >= this.maxActivationsPerGame) {
            return 0;
        }
        if (activationInfo.turnNum != game.getTurnNum()) {
            return this.getMaxActivationsPerTurn(game);
        }
        return Math.max(0, this.getMaxActivationsPerTurn(game) - activationInfo.activationCounter);
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (!this.hasMoreActivationsThisTurn(game) || !super.activate(game, allowedIdentifiers, noMana)) {
            return false;
        }
        ActivationInfo activationInfo = this.getActivationInfo(game);
        if (activationInfo == null) {
            activationInfo = new ActivationInfo(game.getTurnNum(), 1, 0);
        } else if (activationInfo.turnNum != game.getTurnNum()) {
            activationInfo.turnNum = game.getTurnNum();
            activationInfo.activationCounter = 1;
        } else {
            ++activationInfo.activationCounter;
        }
        ++activationInfo.totalActivations;
        this.setActivationInfo(activationInfo, game);
        return true;
    }

    @Override
    public void setMaxActivationsPerTurn(int maxActivationsPerTurn) {
        this.maxActivationsPerTurn = maxActivationsPerTurn;
    }

    @Override
    public int getMaxActivationsPerTurn(Game game) {
        return this.maxActivationsPerTurn;
    }

    protected ActivationInfo getActivationInfo(Game game) {
        Integer turnNum = (Integer)game.getState().getValue(CardUtil.getCardZoneString("activationsTurn" + this.getOriginalId(), this.sourceId, game));
        Integer activationCount = (Integer)game.getState().getValue(CardUtil.getCardZoneString("activationsCount" + this.getOriginalId(), this.sourceId, game));
        Integer totalActivations = (Integer)game.getState().getValue(CardUtil.getCardZoneString("totalActivations" + this.getOriginalId(), this.sourceId, game));
        if (turnNum == null || activationCount == null || totalActivations == null) {
            return null;
        }
        return new ActivationInfo(turnNum, activationCount, totalActivations);
    }

    protected void setActivationInfo(ActivationInfo activationInfo, Game game) {
        game.getState().setValue(CardUtil.getCardZoneString("activationsTurn" + this.getOriginalId(), this.sourceId, game), activationInfo.turnNum);
        game.getState().setValue(CardUtil.getCardZoneString("activationsCount" + this.getOriginalId(), this.sourceId, game), activationInfo.activationCounter);
        game.getState().setValue(CardUtil.getCardZoneString("totalActivations" + this.getOriginalId(), this.sourceId, game), activationInfo.totalActivations);
    }

    @Override
    public ActivatedAbilityImpl setCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    protected static class ActivationInfo {
        public int turnNum;
        public int activationCounter;
        public int totalActivations;

        public ActivationInfo(int turnNum, int activationCounter, int totalActivations) {
            this.turnNum = turnNum;
            this.activationCounter = activationCounter;
            this.totalActivations = totalActivations;
        }
    }
}

