/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.hint.common.CanPlayAdditionalLandsHint;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.Zone;
import mage.game.Game;

public class PlayLandAbility
extends ActivatedAbilityImpl {
    public PlayLandAbility(String cardName) {
        super(AbilityType.PLAY_LAND, Zone.HAND);
        this.usesStack = false;
        this.name = "Play " + cardName;
        this.addHint(CanPlayAdditionalLandsHint.instance);
    }

    protected PlayLandAbility(PlayLandAbility ability) {
        super(ability);
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Set<ApprovingObject> approvingObjects = game.getContinuousEffects().asThough(this.getSourceId(), AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, this, playerId, game);
        if (!this.controlsAbility(playerId, game) && approvingObjects.isEmpty()) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (!(game.isActivePlayer(playerId) && game.getPlayer(playerId).canPlayLand() && game.canPlaySorcery(playerId))) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        if (!approvingObjects.isEmpty()) {
            Card card = game.getCard(this.sourceId);
            Zone zone = game.getState().getZone(this.sourceId);
            if (card != null && card.isOwnedBy(playerId) && Zone.HAND.match(zone)) {
                approvingObjects.add(new ApprovingObject(this, game));
            }
        }
        if (approvingObjects.isEmpty()) {
            return ActivatedAbility.ActivationStatus.withoutApprovingObject(true);
        }
        return new ActivatedAbility.ActivationStatus(approvingObjects);
    }

    @Override
    public String getGameLogMessage(Game game) {
        return " plays " + this.getMessageText(game);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getRule() {
        return this.name;
    }

    @Override
    public PlayLandAbility copy() {
        return new PlayLandAbility(this);
    }
}

