/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.keyword.FlashAbility;
import mage.cards.Card;
import mage.cards.SpellOptionCard;
import mage.cards.SplitCard;
import mage.constants.AbilityType;
import mage.constants.AsThoughEffectType;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

public class SpellAbility
extends ActivatedAbilityImpl {
    protected SpellAbilityType spellAbilityType;
    protected SpellAbilityCastMode spellAbilityCastMode;
    protected String cardName;
    private static final Set<MageIdentifier> activationSetAllowAll = new HashSet<MageIdentifier>();

    public SpellAbility(ManaCost cost, String cardName) {
        this(cost, cardName, Zone.HAND);
    }

    public SpellAbility(ManaCost cost, String cardName, Zone zone) {
        this(cost, cardName, zone, SpellAbilityType.BASE);
    }

    public SpellAbility(ManaCost cost, String cardName, Zone zone, SpellAbilityType spellAbilityType) {
        this(cost, cardName, zone, spellAbilityType, SpellAbilityCastMode.NORMAL);
    }

    public SpellAbility(ManaCost cost, String cardName, Zone zone, SpellAbilityType spellAbilityType, SpellAbilityCastMode spellAbilityCastMode) {
        super(AbilityType.SPELL, zone);
        this.cardName = cardName;
        this.spellAbilityType = spellAbilityType;
        this.spellAbilityCastMode = spellAbilityCastMode;
        this.addCost(cost);
        this.setIdentifier(MageIdentifier.Default);
        this.setSpellName();
    }

    protected SpellAbility(SpellAbility ability) {
        super(ability);
        this.spellAbilityType = ability.spellAbilityType;
        this.spellAbilityCastMode = ability.spellAbilityCastMode;
        this.cardName = ability.cardName;
    }

    @Override
    public boolean canChooseTarget(Game game, UUID playerId) {
        if (SpellAbilityType.SPLIT_FUSED.equals((Object)this.getSpellAbilityType())) {
            Card card = game.getCard(this.getSourceId());
            if (card == null) {
                return false;
            }
            SpellAbility left = ((SplitCard)card).getLeftHalfCard().getSpellAbility();
            SpellAbility right = ((SplitCard)card).getRightHalfCard().getSpellAbility();
            return SpellAbility.canChooseTargetAbility(left, left.getModes(), game, playerId) && SpellAbility.canChooseTargetAbility(right, right.getModes(), game, playerId);
        }
        return super.canChooseTarget(game, playerId);
    }

    public boolean canSpliceOnto(Ability abilityToModify, Game game) {
        return SpellAbility.canChooseTargetAbility(abilityToModify, this.getModes(), game, abilityToModify.getControllerId());
    }

    public Set<MageIdentifier> spellCanBeActivatedNow(UUID playerId, Game game) {
        MageObject object = game.getObject(this.sourceId);
        if (object == null) {
            return Collections.emptySet();
        }
        HashSet<UUID> idsToCheck = new HashSet<UUID>();
        idsToCheck.add(object.getId());
        if (object instanceof Card && !(object instanceof SpellOptionCard)) {
            idsToCheck.add(((Card)object).getMainCard().getId());
        }
        for (UUID idToCheck : idsToCheck) {
            if (game.getState().getValue("PlayFromNotOwnHandZone" + idToCheck) == null) continue;
            if (((Boolean)game.getState().getValue("PlayFromNotOwnHandZone" + idToCheck)).booleanValue()) {
                return activationSetAllowAll;
            }
            return Collections.emptySet();
        }
        Set<ApprovingObject> asInstantApprovers = game.getContinuousEffects().asThough(this.sourceId, AsThoughEffectType.CAST_AS_INSTANT, this, playerId, game);
        if (this.timing == TimingRule.INSTANT || object.isInstant(game) || object.hasAbility(FlashAbility.getInstance(), game) || game.canPlaySorcery(playerId)) {
            return activationSetAllowAll;
        }
        HashSet<MageIdentifier> setOfIdentifier = new HashSet<MageIdentifier>();
        setOfIdentifier.addAll(asInstantApprovers.stream().map(ApprovingObject::getApprovingAbility).map(Ability::getIdentifier).collect(Collectors.toSet()));
        return setOfIdentifier;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Set<MageIdentifier> allowedIdentifiers = this.spellCanBeActivatedNow(playerId, game);
        if (!allowedIdentifiers.isEmpty()) {
            Player player;
            Card card;
            if (this.spellAbilityType == SpellAbilityType.SPLIT || this.spellAbilityType == SpellAbilityType.SPLIT_AFTERMATH) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            Set<Object> approvingObjects = new HashSet<ApprovingObject>();
            approvingObjects.addAll(game.getContinuousEffects().asThough(this.getSourceId(), AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, this, playerId, game));
            approvingObjects.addAll(game.getContinuousEffects().asThough(this.getSourceId(), AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, this, playerId, game));
            if (approvingObjects.isEmpty() && this.getSpellAbilityType().equals((Object)SpellAbilityType.ADVENTURE_SPELL)) {
                approvingObjects = game.getContinuousEffects().asThough(this.getSourceId(), AsThoughEffectType.CAST_ADVENTURE_FROM_NOT_OWN_HAND_ZONE, this, playerId, game);
            }
            if (approvingObjects.isEmpty() && ((card = game.getCard(this.sourceId)) == null || !card.isOwnedBy(playerId))) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (game.inCheckPlayableState()) {
                card = game.getCard(this.sourceId);
                GameEvent castEvent = GameEvent.getEvent(GameEvent.EventType.CAST_SPELL, this.getId(), this, playerId);
                castEvent.setZone(card == null ? null : game.getState().getZone(card.getMainCard().getId()));
                if (game.getContinuousEffects().preventedByRuleModification(castEvent, this, game, true)) {
                    return ActivatedAbility.ActivationStatus.getFalse();
                }
            }
            if (!approvingObjects.isEmpty()) {
                card = game.getCard(this.sourceId);
                Zone zone = game.getState().getZone(this.sourceId);
                if (card != null && card.isOwnedBy(playerId) && Zone.HAND.match(zone)) {
                    approvingObjects.add(new ApprovingObject(this, game));
                }
            }
            if (this.getSpellAbilityType() == SpellAbilityType.BASE_ALTERNATE && (player = game.getPlayer(playerId)) != null && player.getCastSourceIdWithAlternateMana().getOrDefault(this.getSourceId(), Collections.emptySet()).contains((Object)MageIdentifier.Default)) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
            if (this.getCosts().canPay(this, this, playerId, game)) {
                if (this.getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
                    SplitCard splitCard = (SplitCard)game.getCard(this.getSourceId());
                    if (splitCard != null && game.getState().getZone(splitCard.getId()) == Zone.HAND) {
                        return ActivatedAbility.ActivationStatus.withoutApprovingObject(splitCard.getLeftHalfCard().getSpellAbility().canChooseTarget(game, playerId) && splitCard.getRightHalfCard().getSpellAbility().canChooseTarget(game, playerId));
                    }
                    return ActivatedAbility.ActivationStatus.getFalse();
                }
                if (this.canChooseTarget(game, playerId)) {
                    if (approvingObjects == null || approvingObjects.isEmpty()) {
                        return ActivatedAbility.ActivationStatus.withoutApprovingObject(true);
                    }
                    return new ActivatedAbility.ActivationStatus(approvingObjects);
                }
            }
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public String getGameLogMessage(Game game) {
        return this.getMessageText(game);
    }

    @Override
    public String getRule(boolean all) {
        if (all) {
            return super.getRule(true) + this.name;
        }
        return super.getRule(false);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public SpellAbility copy() {
        return new SpellAbility(this);
    }

    public SpellAbility copySpell(Card originalCard, Card copiedCard) {
        Map<UUID, MageObject> mapOldToNew = CardUtil.getOriginalToCopiedPartsMap(originalCard, copiedCard);
        if (!mapOldToNew.containsKey(this.getSourceId())) {
            throw new IllegalStateException("Can't find source id after copy: " + originalCard.getName() + " -> " + copiedCard.getName());
        }
        UUID copiedSourceId = mapOldToNew.getOrDefault(this.getSourceId(), copiedCard).getId();
        SpellAbility spell = new SpellAbility(this);
        spell.newId();
        spell.setSourceId(copiedSourceId);
        return spell;
    }

    public SpellAbilityType getSpellAbilityType() {
        return this.spellAbilityType;
    }

    public void setSpellAbilityType(SpellAbilityType spellAbilityType) {
        this.spellAbilityType = spellAbilityType;
    }

    public String getCardName() {
        return this.cardName;
    }

    public int getConvertedXManaCost(Card card) {
        Map<String, Object> tagMap;
        int xMultiplier = 0;
        if (card == null) {
            return 0;
        }
        for (ManaCost manaCost : card.getManaCost()) {
            if (!(manaCost instanceof VariableManaCost)) continue;
            xMultiplier = ((VariableManaCost)manaCost).getXInstancesCount();
            break;
        }
        if ((tagMap = this.getCostsTagMap()) == null) {
            return 0;
        }
        int amount = (Integer)tagMap.getOrDefault("X", 0);
        return amount * xMultiplier;
    }

    public void setCardName(String cardName) {
        this.cardName = cardName;
        this.setSpellName();
    }

    private void setSpellName() {
        switch (this.spellAbilityType) {
            case SPLIT_FUSED: {
                this.name = "Cast fused " + this.cardName;
                break;
            }
            default: {
                this.name = "Cast " + this.cardName + (this.spellAbilityCastMode != SpellAbilityCastMode.NORMAL ? " using " + this.spellAbilityCastMode.toString() : "");
            }
        }
    }

    public SpellAbilityCastMode getSpellAbilityCastMode() {
        return this.spellAbilityCastMode;
    }

    public void setSpellAbilityCastMode(SpellAbilityCastMode spellAbilityCastMode) {
        this.spellAbilityCastMode = spellAbilityCastMode;
        this.setSpellName();
    }

    public SpellAbility getSpellAbilityToResolve(Game game) {
        return this;
    }

    public Card getCharacteristics(Game game) {
        Card spellCharacteristics = game.getSpell(this.getId());
        if (spellCharacteristics == null) {
            spellCharacteristics = game.getCard(this.getSourceId());
        }
        if (spellCharacteristics != null) {
            if (this.getSpellAbilityCastMode() != SpellAbilityCastMode.NORMAL) {
                spellCharacteristics = this.getSpellAbilityCastMode().getTypeModifiedCardObjectCopy(spellCharacteristics, this, game);
            }
            spellCharacteristics = spellCharacteristics.copy();
        }
        return spellCharacteristics;
    }

    public static SpellAbility getSpellAbilityFromEvent(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.CAST_SPELL && event.getType() != GameEvent.EventType.CAST_SPELL_LATE) {
            return null;
        }
        Card card = game.getCard(event.getSourceId());
        if (card != null) {
            Optional<Ability> ability = card.getAbilities(game).get(event.getTargetId());
            if (ability.isPresent() && ability.get() instanceof SpellAbility) {
                return (SpellAbility)ability.get();
            }
            return card.getSpellAbility();
        }
        return null;
    }

    public void setId(UUID idToUse) {
        this.id = idToUse;
    }

    static {
        activationSetAllowAll.add(MageIdentifier.Default);
    }
}

