/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

public abstract class StateTriggeredAbility
extends TriggeredAbilityImpl {
    protected StateTriggeredAbility(Zone zone, Effect effect) {
        super(zone, effect);
    }

    protected StateTriggeredAbility(StateTriggeredAbility ability) {
        super(ability);
    }

    public boolean canTrigger(Game game) {
        return !Boolean.TRUE.equals(game.getState().getValue(this.getSourceId().toString() + "triggered"));
    }

    @Override
    public final boolean checkEventType(GameEvent event, Game game) {
        return false;
    }

    @Override
    public void trigger(Game game, UUID controllerId, GameEvent triggeringEvent) {
        game.getState().setValue(this.getSourceId().toString() + "triggered", Boolean.TRUE);
        super.trigger(game, controllerId, triggeringEvent);
    }

    @Override
    public boolean resolve(Game game) {
        boolean result = super.resolve(game);
        game.getState().setValue(this.getSourceId().toString() + "triggered", Boolean.FALSE);
        return result;
    }

    public void counter(Game game) {
        game.getState().setValue(this.getSourceId().toString() + "triggered", Boolean.FALSE);
    }
}

