/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.abilityword;

import mage.abilities.abilityword.StriveCostIncreasingEffect;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.constants.AbilityWord;
import mage.constants.Zone;

public class StriveAbility
extends SimpleStaticAbility {
    private final String striveCost;

    public StriveAbility(String manaString) {
        super(Zone.STACK, new StriveCostIncreasingEffect(new ManaCostsImpl(manaString)));
        this.setRuleAtTheTop(true);
        this.striveCost = manaString;
        this.setAbilityWord(AbilityWord.STRIVE);
    }

    protected StriveAbility(StriveAbility ability) {
        super(ability);
        this.striveCost = ability.striveCost;
    }

    @Override
    public StriveAbility copy() {
        return new StriveAbility(this);
    }

    @Override
    public String getRule() {
        return this.abilityWord.formatWord() + "This spell costs " + this.striveCost + " more to cast for each target beyond the first.";
    }
}

