/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.abilityword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.Target;
import mage.util.ManaUtil;

class StriveCostIncreasingEffect
extends CostModificationEffectImpl {
    private ManaCostsImpl striveCosts = null;

    public StriveCostIncreasingEffect(ManaCostsImpl striveCosts) {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.striveCosts = striveCosts;
    }

    protected StriveCostIncreasingEffect(StriveCostIncreasingEffect effect) {
        super(effect);
        this.striveCosts = effect.striveCosts;
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        for (Target target : abilityToModify.getTargets()) {
            if (target.getMaxNumberOfTargets() != Integer.MAX_VALUE) continue;
            int additionalTargets = target.getTargets().size() - 1;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < additionalTargets; ++i) {
                sb.append(this.striveCosts.getText());
            }
            String finalCost = ManaUtil.condenseManaCostString(sb.toString());
            abilityToModify.addManaCostsToPay(new ManaCostsImpl(finalCost));
            return true;
        }
        return false;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility;
    }

    @Override
    public StriveCostIncreasingEffect copy() {
        return new StriveCostIncreasingEffect(this);
    }
}

