/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.assignment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.cards.Card;
import mage.cards.Cards;
import mage.game.Game;

public abstract class RoleAssignment<T>
implements Serializable {
    protected final List<T> attributes = new ArrayList<T>();

    protected RoleAssignment(T ... attributes) {
        for (T attribute : attributes) {
            this.attributes.add(attribute);
        }
    }

    protected abstract Set<T> makeSet(Card var1, Game var2);

    private boolean attemptRearrange(T attribute, UUID uuid, Set<T> attributes, Map<T, UUID> attributeUUIDMap, Map<UUID, Set<T>> attributeSetMap) {
        UUID uuid1 = attributeUUIDMap.get(attribute);
        if (uuid1 == null) {
            return false;
        }
        Set<T> attributes1 = attributeSetMap.get(uuid1);
        for (T attribute1 : attributes1) {
            if (attribute == attribute1 || attributeUUIDMap.containsKey(attribute1)) continue;
            attributeUUIDMap.put(attribute, uuid);
            attributeUUIDMap.put(attribute1, uuid1);
            return true;
        }
        for (T attribute1 : attributes1) {
            if (attribute == attribute1 || !this.attemptRearrange(attribute1, uuid1, attributes, attributeUUIDMap, attributeSetMap)) continue;
            attributeUUIDMap.put(attribute, uuid);
            attributeUUIDMap.put(attribute1, uuid1);
            return true;
        }
        return false;
    }

    public int getRoleCount(Cards cards, Game game) {
        return this.getRoleCount(cards.getCards(game), game);
    }

    public int getRoleCount(Set<? extends Card> cards, Game game) {
        HashMap<UUID, Set<T>> attributeMap = new HashMap<UUID, Set<T>>();
        cards.forEach(card -> attributeMap.put(card.getId(), this.makeSet((Card)card, game)));
        if (attributeMap.size() < 2) {
            return attributeMap.size();
        }
        Set availableTypes = attributeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (attributeMap.size() == 2) {
            return Math.min(2, availableTypes.size());
        }
        HashMap attributeUUIDMap = new HashMap();
        for (Map.Entry entry : attributeMap.entrySet()) {
            for (Object attribute : (Set)entry.getValue()) {
                if (attributeUUIDMap.containsKey(attribute)) continue;
                attributeUUIDMap.put(attribute, entry.getKey());
                break;
            }
            if (attributeUUIDMap.size() >= availableTypes.size()) {
                return attributeUUIDMap.size();
            }
            if (attributeUUIDMap.containsValue(entry.getKey())) continue;
            for (Object attribute : (Set)entry.getValue()) {
                if (this.attemptRearrange(attribute, (UUID)entry.getKey(), (Set)entry.getValue(), attributeUUIDMap, attributeMap)) break;
            }
        }
        return attributeUUIDMap.keySet().size();
    }
}

