/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;

class AnimateDeadDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    public AnimateDeadDelayedTriggeredAbility(FixedTarget fixedTarget) {
        super(new SacrificeTargetEffect("that creature's controller sacrifices it"));
        this.setTriggerPhrase("When {this} leaves the battlefield, ");
        this.getEffects().setTargetPointer(fixedTarget);
    }

    private AnimateDeadDelayedTriggeredAbility(AnimateDeadDelayedTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public AnimateDeadDelayedTriggeredAbility copy() {
        return new AnimateDeadDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return this.getSourceId().equals(event.getTargetId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }
}

