/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

public class AttacksOpponentWithMostLifeTriggeredAbility
extends TriggeredAbilityImpl {
    public AttacksOpponentWithMostLifeTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever this creature attacks a player, if no opponent has more life than that player, ");
    }

    private AttacksOpponentWithMostLifeTriggeredAbility(AttacksOpponentWithMostLifeTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getCombat().getAttackers().contains(this.getSourceId()) && game.getPlayer(game.getCombat().getDefenderId(this.getSourceId())) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkInterveningIfClause(Game game) {
        Player defender = game.getPlayer(game.getCombat().getDefenderId(this.getSourceId()));
        if (defender == null) return false;
        if (game.getOpponents(this.getControllerId(), true).stream().map(game::getPlayer).filter(Objects::nonNull).mapToInt(Player::getLife).max().orElse(Integer.MIN_VALUE) > defender.getLife()) return false;
        return true;
    }

    @Override
    public AttacksOpponentWithMostLifeTriggeredAbility copy() {
        return new AttacksOpponentWithMostLifeTriggeredAbility(this);
    }
}

