/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;

public class AttacksTriggeredAbility
extends TriggeredAbilityImpl {
    protected final String text;
    protected final SetTargetPointer setTargetPointer;

    public AttacksTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public AttacksTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, null);
    }

    public AttacksTriggeredAbility(Effect effect, boolean optional, String text) {
        this(effect, optional, text, SetTargetPointer.NONE);
    }

    public AttacksTriggeredAbility(Effect effect, boolean optional, String text, SetTargetPointer setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.text = text;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever {this} attacks, ");
        this.withRuleTextReplacement(true);
    }

    protected AttacksTriggeredAbility(AttacksTriggeredAbility ability) {
        super(ability);
        this.text = ability.text;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defendingPlayerId;
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) {
            return false;
        }
        if (this.setTargetPointer == SetTargetPointer.PLAYER && (defendingPlayerId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game)) != null) {
            this.getEffects().setTargetPointer(new FixedTarget(defendingPlayerId));
        }
        return true;
    }

    @Override
    public String getRule() {
        if (this.text == null || this.text.isEmpty()) {
            return super.getRule();
        }
        return this.text;
    }

    @Override
    public AttacksTriggeredAbility copy() {
        return new AttacksTriggeredAbility(this);
    }
}

