/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesAuraSourceEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

public class BecomesAuraAttachToManifestSourceEffect
extends OneShotEffect {
    public BecomesAuraAttachToManifestSourceEffect() {
        super(Outcome.Benefit);
        this.staticText = "it becomes an Aura with enchant creature. Manifest the top card of your library and attach {this} to it";
    }

    protected BecomesAuraAttachToManifestSourceEffect(BecomesAuraAttachToManifestSourceEffect effect) {
        super(effect);
    }

    @Override
    public BecomesAuraAttachToManifestSourceEffect copy() {
        return new BecomesAuraAttachToManifestSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (controller != null && enchantment != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                new ManifestEffect(1).apply(game, source);
                Permanent enchantedCreature = CardUtil.getPermanentFromCardPutToBattlefield(card, game);
                if (enchantedCreature != null) {
                    enchantedCreature.addAttachment(enchantment.getId(), source, game);
                    FilterCreaturePermanent filter = new FilterCreaturePermanent();
                    TargetPermanent target = new TargetPermanent(filter);
                    target.addTarget(enchantedCreature.getId(), source, game);
                    game.addEffect(new BecomesAuraSourceEffect(target), source);
                }
            }
            return true;
        }
        return false;
    }
}

