/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.FilterStackObject;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;

public class BecomesTargetControllerTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filterTarget;
    private final FilterStackObject filterStack;
    private final SetTargetPointer setTargetPointer;

    public BecomesTargetControllerTriggeredAbility(Effect effect, FilterPermanent filterTarget, FilterStackObject filterStack, SetTargetPointer setTargetPointer, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.filterTarget = filterTarget;
        this.filterStack = filterStack;
        this.setTargetPointer = setTargetPointer;
        String filterMessage = filterTarget == null ? "you become" : "you or " + filterTarget.getMessage() + " becomes";
        this.setTriggerPhrase("Whenever " + filterMessage + " the target of " + filterStack.getMessage() + ", ");
    }

    protected BecomesTargetControllerTriggeredAbility(BecomesTargetControllerTriggeredAbility ability) {
        super(ability);
        this.filterTarget = ability.filterTarget;
        this.filterStack = ability.filterStack;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public BecomesTargetControllerTriggeredAbility copy() {
        return new BecomesTargetControllerTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGETED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!(event.getTargetId().equals(this.getControllerId()) || (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && this.filterTarget != null && this.filterTarget.match(permanent, this.getControllerId(), (Ability)this, game))) {
            return false;
        }
        StackObject targetingObject = game.findTargetingStackObject(this.getId().toString(), event);
        if (targetingObject == null || !this.filterStack.match(targetingObject, this.getControllerId(), this, game)) {
            return false;
        }
        switch (this.setTargetPointer) {
            case SPELL: {
                this.getAllEffects().setTargetPointer(new FixedTarget(targetingObject.getId()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SetTargetPointer in BecomesTargetControllerTriggeredAbility");
            }
        }
        return true;
    }
}

