/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class CantFlashUnlessConditionEffect
extends ContinuousRuleModifyingEffectImpl {
    private final Condition condition;

    public CantFlashUnlessConditionEffect(Condition condition) {
        super(Duration.EndOfGame, Outcome.Neutral);
        this.condition = condition;
    }

    private CantFlashUnlessConditionEffect(CantFlashUnlessConditionEffect effect) {
        super(effect);
        this.condition = effect.condition;
    }

    @Override
    public CantFlashUnlessConditionEffect copy() {
        return new CantFlashUnlessConditionEffect(this);
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getSourceId().equals(source.getSourceId())) {
            return false;
        }
        if (game.inCheckPlayableState()) {
            return false;
        }
        if (game.isMainPhase() && game.isActivePlayer(event.getPlayerId()) && game.getStack().size() == 1) {
            return false;
        }
        if (Boolean.TRUE.equals(game.getState().getValue("PlayFromNotOwnHandZone" + source.getSourceId()))) {
            return false;
        }
        return !this.condition.apply(game, source);
    }
}

