/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.CaseSolveAbility;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SolvedSourceCondition;
import mage.abilities.decorator.ConditionalAsThoughEffect;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.decorator.ConditionalReplacementEffect;
import mage.abilities.effects.Effect;
import mage.constants.Zone;

public class CaseAbility
extends SimpleStaticAbility {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CaseAbility(Ability initialAbility, Condition toSolveCondition, Ability solvedAbility) {
        super(Zone.ALL, null);
        if (initialAbility instanceof EntersBattlefieldTriggeredAbility) {
            ((EntersBattlefieldTriggeredAbility)initialAbility).setTriggerPhrase("When this Case enters, ");
        }
        this.addSubAbility(initialAbility);
        this.addSubAbility(new CaseSolveAbility(toSolveCondition));
        if (!(solvedAbility instanceof ActivateIfConditionActivatedAbility)) {
            if (solvedAbility instanceof TriggeredAbility) {
                if (!(((TriggeredAbility)solvedAbility).getTriggerCondition() instanceof SolvedSourceCondition)) {
                    throw new IllegalArgumentException("Wrong code usage: if solvedAbility is a TriggeredAbility it must have SolvedSourceCondition as its trigger condition");
                }
            } else {
                if (!(solvedAbility instanceof SimpleStaticAbility)) throw new IllegalArgumentException("Wrong code usage: solvedAbility must be one of ActivateIfConditionActivatedAbility, TriggeredAbility, or StaticAbility with conditional effects.");
                for (Effect effect : solvedAbility.getEffects()) {
                    if (effect instanceof ConditionalContinuousEffect || effect instanceof ConditionalAsThoughEffect || effect instanceof ConditionalReplacementEffect) continue;
                    throw new IllegalArgumentException("Wrong code usage: solvedAbility must be one of ActivateIfConditionActivatedAbility, TriggeredAbility, or StaticAbility with conditional effects.");
                }
            }
        } else {
            ((ActivateIfConditionActivatedAbility)solvedAbility).hideCondition();
        }
        this.addSubAbility(solvedAbility.withFlavorWord("Solved"));
    }

    protected CaseAbility(CaseAbility ability) {
        super(ability);
    }

    @Override
    public CaseAbility copy() {
        return new CaseAbility(this);
    }
}

