/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Objects;
import java.util.Optional;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class CastExiledFromHandCardEffect
extends OneShotEffect {
    CastExiledFromHandCardEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may cast {this} for as long as it remains exiled";
    }

    private CastExiledFromHandCardEffect(CastExiledFromHandCardEffect effect) {
        super(effect);
    }

    @Override
    public CastExiledFromHandCardEffect copy() {
        return new CastExiledFromHandCardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Optional.ofNullable(this.getValue("exiledHandCardRef")).filter(Objects::nonNull).map(MageObjectReference.class::cast).map(mor -> mor.getCard(game)).ifPresent(card -> CardUtil.makeCardPlayable(game, source, card, true, Duration.Custom, false));
        return true;
    }
}

