/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

public class CastOnlyIfConditionIsTrueEffect
extends ContinuousRuleModifyingEffectImpl {
    private final Condition condition;

    public CastOnlyIfConditionIsTrueEffect(Condition condition) {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.condition = condition;
        this.staticText = this.setText();
    }

    private CastOnlyIfConditionIsTrueEffect(CastOnlyIfConditionIsTrueEffect effect) {
        super(effect);
        this.condition = effect.condition;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(source.getSourceId()) && this.condition != null && !this.condition.apply(game, source);
    }

    @Override
    public CastOnlyIfConditionIsTrueEffect copy() {
        return new CastOnlyIfConditionIsTrueEffect(this);
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("cast this spell only if ");
        if (this.condition != null) {
            sb.append(this.condition);
        }
        return sb.toString();
    }
}

