/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility
extends TriggeredAbilityImpl {
    protected final boolean setTargetPointer;

    public DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, false);
    }

    public DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility(Effect effect, boolean optional, boolean setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("Whenever {this} deals combat damage to a player or planeswalker, ");
        this.setTargetPointer = setTargetPointer;
    }

    protected DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility(DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility copy() {
        return new DealsCombatDamageToAPlayerOrPlaneswalkerTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!event.getSourceId().equals(this.getSourceId()) || !((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (!(event.getType() != GameEvent.EventType.DAMAGED_PERMANENT || (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isPlaneswalker(game))) {
            return false;
        }
        this.getAllEffects().setValue("damage", event.getAmount());
        if (this.setTargetPointer) {
            this.getAllEffects().setTargetPointer(new FixedTarget(event.getPlayerId()));
        }
        return true;
    }
}

