/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchBySourceEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

public class DealsCombatDamageTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedEvent> {
    public DealsCombatDamageTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase(this.getWhen() + "{this} deals combat damage, ");
        this.withRuleTextReplacement(true);
    }

    protected DealsCombatDamageTriggeredAbility(DealsCombatDamageTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DealsCombatDamageTriggeredAbility copy() {
        return new DealsCombatDamageTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.getSourceId()) || !((DamagedBatchBySourceEvent)event).isCombatDamage()) {
            return false;
        }
        this.getEffects().setValue("damage", event.getAmount());
        return true;
    }
}

