/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class DealsDamageToACreatureTriggeredAbility
extends TriggeredAbilityImpl {
    protected boolean combatOnly;
    private final boolean setTargetPointer;
    private FilterCreaturePermanent filter;

    public DealsDamageToACreatureTriggeredAbility(Effect effect, boolean combatOnly, boolean optional, boolean setTargetPointer) {
        this(effect, combatOnly, optional, setTargetPointer, StaticFilters.FILTER_PERMANENT_A_CREATURE);
    }

    public DealsDamageToACreatureTriggeredAbility(Effect effect, boolean combatOnly, boolean optional, boolean setTargetPointer, FilterCreaturePermanent filter) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.combatOnly = combatOnly;
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase("Whenever {this} deals " + (combatOnly ? "combat " : "") + "damage to " + filter.getMessage() + ", ");
    }

    protected DealsDamageToACreatureTriggeredAbility(DealsDamageToACreatureTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
        this.combatOnly = ability.combatOnly;
        this.filter = ability.filter;
    }

    @Override
    public DealsDamageToACreatureTriggeredAbility copy() {
        return new DealsDamageToACreatureTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getSourceId().equals(this.sourceId) && (!this.combatOnly || ((DamagedEvent)event).isCombatDamage())) {
            Permanent creature = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (!this.filter.match(creature, this.getControllerId(), (Ability)this, game)) {
                return false;
            }
            this.getEffects().setValue("damagedCreature", game.getPermanent(event.getTargetId()));
            if (this.setTargetPointer) {
                this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId(), game));
                this.getEffects().setValue("damage", event.getAmount());
            }
            return true;
        }
        return false;
    }
}

