/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class DealsDamageToAPlayerAllTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filter;
    private final SetTargetPointer setTargetPointer;
    private final boolean onlyCombat;
    private final boolean affectsDefendingPlayer;
    private final TargetController targetController;

    public DealsDamageToAPlayerAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyCombat) {
        this(effect, filter, optional, setTargetPointer, onlyCombat, false);
    }

    public DealsDamageToAPlayerAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyCombat, boolean affectsDefendingPlayer) {
        this(Zone.BATTLEFIELD, effect, filter, optional, setTargetPointer, onlyCombat, affectsDefendingPlayer);
    }

    public DealsDamageToAPlayerAllTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyCombat, boolean affectsDefendingPlayer, TargetController targetController) {
        this(Zone.BATTLEFIELD, effect, filter, optional, setTargetPointer, onlyCombat, affectsDefendingPlayer, targetController);
    }

    public DealsDamageToAPlayerAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyCombat, boolean affectsDefendingPlayer) {
        this(zone, effect, filter, optional, setTargetPointer, onlyCombat, affectsDefendingPlayer, TargetController.ANY);
    }

    public DealsDamageToAPlayerAllTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, boolean optional, SetTargetPointer setTargetPointer, boolean onlyCombat, boolean affectsDefendingPlayer, TargetController targetController) {
        super(zone, effect, optional);
        this.setTargetPointer = setTargetPointer;
        this.filter = filter;
        this.onlyCombat = onlyCombat;
        this.affectsDefendingPlayer = affectsDefendingPlayer;
        this.targetController = targetController;
        this.setTriggerPhrase("Whenever " + CardUtil.addArticle(filter.getMessage()) + " deals " + (onlyCombat ? "combat " : "") + "damage to " + (targetController == TargetController.OPPONENT ? "an opponent" : "a player") + ", ");
    }

    protected DealsDamageToAPlayerAllTriggeredAbility(DealsDamageToAPlayerAllTriggeredAbility ability) {
        super(ability);
        this.setTargetPointer = ability.setTargetPointer;
        this.filter = ability.filter;
        this.onlyCombat = ability.onlyCombat;
        this.affectsDefendingPlayer = ability.affectsDefendingPlayer;
        this.targetController = ability.targetController;
    }

    @Override
    public DealsDamageToAPlayerAllTriggeredAbility copy() {
        return new DealsDamageToAPlayerAllTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.onlyCombat && !((DamagedPlayerEvent)event).isCombatDamage()) {
            return false;
        }
        if (this.targetController == TargetController.OPPONENT && !game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (!this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setValue("damage", event.getAmount());
        this.getEffects().setValue("sourceId", event.getSourceId());
        if (this.affectsDefendingPlayer) {
            this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId()));
        } else {
            switch (this.setTargetPointer) {
                case PLAYER: {
                    this.getEffects().setTargetPointer(new FixedTarget(permanent.getControllerId()));
                    break;
                }
                case PERMANENT: {
                    this.getEffects().setTargetPointer(new FixedTarget(permanent, game));
                }
            }
        }
        return true;
    }
}

