/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.DrawNthCardWatcher;
import mage.abilities.dynamicvalue.common.CardsDrawnThisTurnDynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class DrawNthCardTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Hint hint = new ValueHint("Cards drawn this turn", CardsDrawnThisTurnDynamicValue.instance);
    private final TargetController targetController;
    private final int cardNumber;

    public DrawNthCardTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public DrawNthCardTriggeredAbility(Effect effect, boolean optional) {
        this(effect, optional, 2);
    }

    public DrawNthCardTriggeredAbility(Effect effect, boolean optional, int cardNumber) {
        this(effect, optional, TargetController.YOU, cardNumber);
    }

    public DrawNthCardTriggeredAbility(Effect effect, boolean optional, TargetController targetController, int cardNumber) {
        this(Zone.BATTLEFIELD, effect, optional, targetController, cardNumber);
    }

    public DrawNthCardTriggeredAbility(Zone zone, Effect effect, boolean optional, TargetController targetController, int cardNumber) {
        super(zone, effect, optional);
        this.targetController = targetController;
        this.cardNumber = cardNumber;
        if (targetController == TargetController.YOU) {
            this.addHint(hint);
        }
        this.setTriggerPhrase(this.generateTriggerPhrase());
        this.addWatcher(new DrawNthCardWatcher());
    }

    protected DrawNthCardTriggeredAbility(DrawNthCardTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.cardNumber = ability.cardNumber;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        switch (this.targetController) {
            case YOU: {
                if (this.isControlledBy(event.getPlayerId())) break;
                return false;
            }
            case ACTIVE: {
                if (game.isActivePlayer(event.getPlayerId())) break;
                return false;
            }
            case OPPONENT: {
                if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) break;
                return false;
            }
            case ANY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
            }
        }
        return DrawNthCardWatcher.checkEvent(event.getPlayerId(), event.getId(), game) + 1 == this.cardNumber;
    }

    public String generateTriggerPhrase() {
        switch (this.targetController) {
            case YOU: {
                return "Whenever you draw your " + CardUtil.numberToOrdinalText(this.cardNumber) + " card each turn, ";
            }
            case ACTIVE: {
                return "Whenever a player draws their " + CardUtil.numberToOrdinalText(this.cardNumber) + " card during their turn, ";
            }
            case OPPONENT: {
                return "Whenever an opponent draws their " + CardUtil.numberToOrdinalText(this.cardNumber) + " card each turn, ";
            }
            case ANY: {
                return "Whenever a player draws their " + CardUtil.numberToOrdinalText(this.cardNumber) + " card each turn, ";
            }
        }
        throw new IllegalArgumentException("TargetController " + (Object)((Object)this.targetController) + " not supported");
    }

    @Override
    public DrawNthCardTriggeredAbility copy() {
        return new DrawNthCardTriggeredAbility(this);
    }
}

