/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.EscapeAbility;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EscapesWithEffect
extends OneShotEffect {
    private final int counter;
    private final TriggeredAbility triggeredAbility;

    EscapesWithEffect(int counter, TriggeredAbility triggeredAbility) {
        super(Outcome.BoostCreature);
        this.counter = counter;
        this.triggeredAbility = triggeredAbility;
    }

    private EscapesWithEffect(EscapesWithEffect effect) {
        super(effect);
        this.counter = effect.counter;
        this.triggeredAbility = effect.triggeredAbility == null ? null : effect.triggeredAbility.copy();
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (permanent == null) {
            return false;
        }
        SpellAbility spellAbility = (SpellAbility)this.getValue("sourceCastSpellAbility");
        if (!(spellAbility instanceof EscapeAbility) || !spellAbility.getSourceId().equals(source.getSourceId()) || permanent.getZoneChangeCounter(game) != spellAbility.getStackMomentSourceZCC()) {
            return false;
        }
        if (this.counter > 0) {
            List appliedEffects = (List)this.getValue("appliedEffects");
            permanent.addCounters(CounterType.P1P1.createInstance(this.counter), source.getControllerId(), source, game, appliedEffects);
        }
        if (this.triggeredAbility != null) {
            if (this.triggeredAbility instanceof DelayedTriggeredAbility) {
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)this.triggeredAbility, source);
            } else {
                GainAbilitySourceEffect gainsAbilityEffect = new GainAbilitySourceEffect(this.triggeredAbility);
                game.addEffect(gainsAbilityEffect, source);
            }
        }
        return true;
    }

    @Override
    public EscapesWithEffect copy() {
        return new EscapesWithEffect(this);
    }
}

