/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.SagaAbility;
import mage.abilities.effects.Effect;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class FinalChapterAbilityResolvesTriggeredAbility
extends TriggeredAbilityImpl {
    private final boolean rememberSaga;

    public FinalChapterAbilityResolvesTriggeredAbility(Effect effect) {
        this(effect, false);
    }

    public FinalChapterAbilityResolvesTriggeredAbility(Effect effect, boolean rememberSaga) {
        super(Zone.BATTLEFIELD, effect, false);
        this.rememberSaga = rememberSaga;
        this.setTriggerPhrase("Whenever the final chapter ability of a Saga you control resolves, ");
    }

    private FinalChapterAbilityResolvesTriggeredAbility(FinalChapterAbilityResolvesTriggeredAbility ability) {
        super(ability);
        this.rememberSaga = ability.rememberSaga;
    }

    @Override
    public FinalChapterAbilityResolvesTriggeredAbility copy() {
        return new FinalChapterAbilityResolvesTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.RESOLVING_ABILITY;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Optional<Ability> ability_opt = game.getAbility(event.getTargetId(), event.getSourceId());
        if (!ability_opt.isPresent()) {
            return false;
        }
        Ability ability = ability_opt.get();
        if (!ability.isTriggeredAbility()) {
            return false;
        }
        TriggeredAbility triggeredAbility = (TriggeredAbility)ability;
        if (!SagaAbility.isChapterAbility(triggeredAbility)) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (permanent == null || !permanent.isControlledBy(this.getControllerId()) || !permanent.hasSubtype(SubType.SAGA, game)) {
            return false;
        }
        int maxChapter = CardUtil.castStream(permanent.getAbilities(game).stream(), SagaAbility.class).map(SagaAbility::getMaxChapter).mapToInt(SagaChapter::getNumber).sum();
        if (!SagaAbility.isFinalAbility(triggeredAbility, maxChapter)) {
            return false;
        }
        if (this.rememberSaga) {
            this.getEffects().setTargetPointer(new FixedTarget(permanent.getId(), game));
        }
        return true;
    }
}

