/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class GainLifeFirstTimeWatcher
extends Watcher {
    private final Map<UUID, UUID> gainedMap = new HashMap<UUID, UUID>();

    GainLifeFirstTimeWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.GAINED_LIFE || event.getAmount() < 1) {
            return;
        }
        this.gainedMap.putIfAbsent(event.getPlayerId(), event.getId());
    }

    @Override
    public void reset() {
        super.reset();
        this.gainedMap.clear();
    }

    boolean checkEvent(UUID playerId, GameEvent event) {
        return event.getId().equals(this.gainedMap.getOrDefault(playerId, null));
    }

    boolean checkGain(UUID playerId) {
        return !this.gainedMap.containsKey(playerId);
    }
}

