/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Arrays;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.WasCastFromExileWatcher;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BasicManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GainManaAbilitiesWhileExiledEffect
extends ContinuousEffectImpl {
    private final String colors;

    GainManaAbilitiesWhileExiledEffect(String colors) {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.colors = colors;
        this.staticText = "target land gains \"{T}: Add " + CardUtil.concatWithOr(Arrays.stream(colors.split("")).map(s -> '{' + s + '}').collect(Collectors.toList())) + "\" until {this} is cast from exile";
    }

    private GainManaAbilitiesWhileExiledEffect(GainManaAbilitiesWhileExiledEffect effect) {
        super(effect);
        this.colors = effect.colors;
    }

    @Override
    public GainManaAbilitiesWhileExiledEffect copy() {
        return new GainManaAbilitiesWhileExiledEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (WasCastFromExileWatcher.check((MageObjectReference)this.getValue("exiledHandCardRef"), game)) {
            this.discard();
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        block7: for (char c : this.colors.toCharArray()) {
            BasicManaAbility ability;
            switch (c) {
                case 'W': {
                    ability = new WhiteManaAbility();
                    break;
                }
                case 'U': {
                    ability = new BlueManaAbility();
                    break;
                }
                case 'B': {
                    ability = new BlackManaAbility();
                    break;
                }
                case 'R': {
                    ability = new RedManaAbility();
                    break;
                }
                case 'G': {
                    ability = new GreenManaAbility();
                    break;
                }
                default: {
                    continue block7;
                }
            }
            permanent.addAbility(ability, source.getSourceId(), game);
        }
        return true;
    }
}

