/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.GodEternalEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class GodEternalDiesTriggeredAbility
extends TriggeredAbilityImpl {
    public GodEternalDiesTriggeredAbility() {
        super(Zone.ALL, null, true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private GodEternalDiesTriggeredAbility(GodEternalDiesTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            return zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED);
        }
        return false;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTargetId().equals(this.getSourceId())) {
            this.getEffects().clear();
            this.addEffect(new GodEternalEffect(new MageObjectReference(zEvent.getTarget(), game)));
            return true;
        }
        return false;
    }

    @Override
    public GodEternalDiesTriggeredAbility copy() {
        return new GodEternalDiesTriggeredAbility(this);
    }

    @Override
    public String getRule() {
        return "When {this} dies or is put into exile from the battlefield, you may put it into its owner's library third from the top.";
    }
}

