/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.RemoveSpecialActionEffect;
import mage.constants.Outcome;
import mage.game.Game;

class LicidSpecialActionEffect
extends OneShotEffect {
    private final UUID messageId;
    private final UUID generatingSpecialActionId;

    LicidSpecialActionEffect(UUID messageId, UUID generatingSpecialActionId, String licidName) {
        super(Outcome.Neutral);
        this.messageId = messageId;
        this.generatingSpecialActionId = generatingSpecialActionId;
        this.staticText = "End " + licidName + " Effect";
    }

    LicidSpecialActionEffect(LicidSpecialActionEffect effect) {
        super(effect);
        this.messageId = effect.messageId;
        this.generatingSpecialActionId = effect.generatingSpecialActionId;
    }

    @Override
    public LicidSpecialActionEffect copy() {
        return new LicidSpecialActionEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        new RemoveSpecialActionEffect(this.generatingSpecialActionId).apply(game, source);
        game.getState().setValue(this.messageId.toString(), true);
        return true;
    }
}

