/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.ActivatedAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.constants.TimingRule;
import mage.constants.Zone;
import mage.util.CardUtil;

public class LimitedTimesPerTurnActivatedAbility
extends ActivatedAbilityImpl {
    public LimitedTimesPerTurnActivatedAbility(Effect effect, Cost cost) {
        this(Zone.BATTLEFIELD, effect, cost);
    }

    public LimitedTimesPerTurnActivatedAbility(Zone zone, Effect effect, Cost cost) {
        this(zone, effect, cost, 1);
    }

    public LimitedTimesPerTurnActivatedAbility(Zone zone, Effect effect, Cost cost, int maxActivationsPerTurn) {
        this(zone, effect, cost, maxActivationsPerTurn, null);
    }

    public LimitedTimesPerTurnActivatedAbility(Zone zone, Effect effect, Cost cost, int maxActivationsPerTurn, Condition condition) {
        super(zone, effect, cost);
        this.maxActivationsPerTurn = maxActivationsPerTurn;
        this.condition = condition;
    }

    protected LimitedTimesPerTurnActivatedAbility(LimitedTimesPerTurnActivatedAbility ability) {
        super(ability);
        this.maxActivationsPerTurn = ability.maxActivationsPerTurn;
        this.condition = ability.condition;
    }

    @Override
    public String getRule() {
        StringBuilder sb = new StringBuilder(super.getRule()).append(" Activate ");
        if (this.condition != null) {
            String message = this.condition.toString();
            sb.append("only ").append(message.startsWith("if ") || message.startsWith("during") ? message : "if " + message).append(" and ");
        }
        if (this.getTiming() == TimingRule.SORCERY) {
            sb.append("only as a sorcery and ");
        }
        switch (this.maxActivationsPerTurn) {
            case 1: {
                sb.append("only once");
                break;
            }
            case 2: {
                sb.append("no more than twice");
                break;
            }
            default: {
                sb.append("no more than ").append(CardUtil.numberToText(this.maxActivationsPerTurn)).append(" times");
            }
        }
        sb.append(" each turn.");
        return sb.toString();
    }

    @Override
    public LimitedTimesPerTurnActivatedAbility copy() {
        return new LimitedTimesPerTurnActivatedAbility(this);
    }
}

