/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.common.SavedLifeLossValue;
import mage.abilities.effects.Effect;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.LifeLostEvent;
import mage.target.targetpointer.FixedTarget;

public class LoseLifeTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<LifeLostEvent> {
    protected final TargetController targetController;
    private final boolean setTargetPointer;

    public LoseLifeTriggeredAbility(Effect effect) {
        this(effect, TargetController.YOU, false, false);
    }

    public LoseLifeTriggeredAbility(Effect effect, TargetController targetController, boolean optional, boolean setTargetPointer) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.targetController = targetController;
        this.setTargetPointer = setTargetPointer;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected LoseLifeTriggeredAbility(LoseLifeTriggeredAbility ability) {
        super(ability);
        this.targetController = ability.targetController;
        this.setTargetPointer = ability.setTargetPointer;
    }

    @Override
    public LoseLifeTriggeredAbility copy() {
        return new LoseLifeTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_LIFE_BATCH_FOR_ONE_PLAYER;
    }

    private boolean filterPlayer(UUID playerId, Game game) {
        switch (this.targetController) {
            case YOU: {
                return this.isControlledBy(playerId);
            }
            case OPPONENT: {
                return game.getOpponents(this.getControllerId()).contains(playerId);
            }
        }
        throw new IllegalArgumentException("Wrong code usage: not supported targetController: " + (Object)((Object)this.targetController));
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.filterPlayer(event.getTargetId(), game)) {
            return false;
        }
        this.getEffects().setValue(SavedLifeLossValue.getValueKey(), event.getAmount());
        if (this.setTargetPointer) {
            this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId()));
        }
        return true;
    }

    protected String generateTriggerPhrase() {
        switch (this.targetController) {
            case YOU: {
                return "Whenever you lose life, ";
            }
            case OPPONENT: {
                return "Whenever an opponent loses life, ";
            }
        }
        throw new IllegalArgumentException("Wrong code usage: not supported targetController: " + (Object)((Object)this.targetController));
    }
}

