/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class PhaseInTriggeredAbility
extends TriggeredAbilityImpl {
    private FilterPermanent filter;

    public PhaseInTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(effect, filter, false);
    }

    public PhaseInTriggeredAbility(Effect effect, FilterPermanent filter, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.filter = filter;
        this.setTriggerPhrase("Whenever " + filter.getMessage() + " phases in, ");
    }

    protected PhaseInTriggeredAbility(PhaseInTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
    }

    @Override
    public PhaseInTriggeredAbility copy() {
        return new PhaseInTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASED_IN;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && this.filter.match(permanent, this.getControllerId(), (Ability)this, game);
    }
}

