/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.SetTargetPointer;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

public class SacrificePermanentTriggeredAbility
extends TriggeredAbilityImpl {
    private final FilterPermanent filter;
    private final SetTargetPointer setTargetPointer;
    private final TargetController sacrificingPlayer;

    public SacrificePermanentTriggeredAbility(Effect effect, FilterPermanent filter) {
        this(effect, filter, TargetController.YOU);
    }

    public SacrificePermanentTriggeredAbility(Effect effect, FilterPermanent filter, TargetController sacrificingPlayer) {
        this(Zone.BATTLEFIELD, effect, filter, sacrificingPlayer, SetTargetPointer.NONE, false);
    }

    public SacrificePermanentTriggeredAbility(Zone zone, Effect effect, FilterPermanent filter, TargetController sacrificingPlayer, SetTargetPointer setTargetPointer, boolean optional) {
        super(zone, effect, optional);
        if (Zone.BATTLEFIELD.match(zone)) {
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.filter = filter;
        this.setTargetPointer = setTargetPointer;
        this.sacrificingPlayer = sacrificingPlayer;
        this.setTriggerPhrase(this.generateTriggerPhrase());
    }

    protected SacrificePermanentTriggeredAbility(SacrificePermanentTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
        this.setTargetPointer = ability.setTargetPointer;
        this.sacrificingPlayer = ability.sacrificingPlayer;
    }

    @Override
    public SacrificePermanentTriggeredAbility copy() {
        return new SacrificePermanentTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SACRIFICED_PERMANENT;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        switch (this.sacrificingPlayer) {
            case YOU: {
                if (event.getPlayerId().equals(this.getControllerId())) break;
                return false;
            }
            case OPPONENT: {
                Player controller = game.getPlayer(this.getControllerId());
                if (controller != null && controller.hasOpponent(event.getPlayerId(), game)) break;
                return false;
            }
            case ANY: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TargetController in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.sacrificingPlayer));
            }
        }
        if ((permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) == null || !this.filter.match(permanent, this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        this.getEffects().setValue("sacrificedPermanent", permanent);
        switch (this.setTargetPointer) {
            case PERMANENT: {
                this.getEffects().setTargetPointer(new FixedTarget(event.getTargetId(), game));
                break;
            }
            case PLAYER: {
                this.getEffects().setTargetPointer(new FixedTarget(event.getPlayerId(), game));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SetTargetPointer in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.setTargetPointer));
            }
        }
        return true;
    }

    private String generateTriggerPhrase() {
        String targetControllerText;
        switch (this.sacrificingPlayer) {
            case YOU: {
                targetControllerText = "you sacrifice ";
                break;
            }
            case OPPONENT: {
                targetControllerText = "an opponent sacrifices ";
                break;
            }
            case ANY: {
                targetControllerText = "a player sacrifices ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported TargetController in SacrificePermanentTriggeredAbility: " + (Object)((Object)this.sacrificingPlayer));
            }
        }
        return this.getWhen() + targetControllerText + CardUtil.addArticle(this.filter.getMessage()) + ", ";
    }
}

