/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.function.Consumer;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.ChapterTriggeredAbility;
import mage.abilities.common.EntersBattlefieldAbility;
import mage.abilities.common.GainReadAheadAbility;
import mage.abilities.common.SagaLoreCountersEffect;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.Effects;
import mage.abilities.keyword.ReadAheadAbility;
import mage.cards.Card;
import mage.constants.SagaChapter;
import mage.constants.Zone;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.Target;

public class SagaAbility
extends SimpleStaticAbility {
    private final SagaChapter maxChapter;
    private boolean showSacText;
    private final boolean readAhead;

    public SagaAbility(Card card) {
        this(card, SagaChapter.CHAPTER_III, false);
    }

    public SagaAbility(Card card, SagaChapter maxChapter) {
        this(card, maxChapter, false);
    }

    public SagaAbility(Card card, SagaChapter maxChapter, boolean readAhead) {
        super(Zone.ALL, null);
        this.maxChapter = maxChapter;
        this.showSacText = card.getSecondCardFace() == null && !card.isNightCard();
        this.readAhead = readAhead;
        this.setRuleVisible(true);
        this.setRuleAtTheTop(true);
        EntersBattlefieldAbility ability = new EntersBattlefieldAbility(new SagaLoreCountersEffect(maxChapter));
        ability.setRuleVisible(false);
        card.addAbility(ability);
        if (readAhead) {
            card.addAbility(ReadAheadAbility.getInstance());
        }
    }

    protected SagaAbility(SagaAbility ability) {
        super(ability);
        this.maxChapter = ability.maxChapter;
        this.showSacText = ability.showSacText;
        this.readAhead = ability.readAhead;
    }

    public void addChapterEffect(Card card, SagaChapter chapter, Effect ... effects) {
        this.addChapterEffect(card, chapter, chapter, new Effects(effects));
    }

    public void addChapterEffect(Card card, SagaChapter chapter, Effect effect, Target target) {
        this.addChapterEffect(card, chapter, chapter, new Effects(effect), target);
    }

    public void addChapterEffect(Card card, SagaChapter chapter, Effects effects, Target target) {
        this.addChapterEffect(card, chapter, chapter, effects, target);
    }

    public void addChapterEffect(Card card, SagaChapter chapter, Consumer<TriggeredAbility> applier) {
        this.addChapterEffect(card, chapter, chapter, applier);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effect effect) {
        this.addChapterEffect(card, fromChapter, toChapter, new Effects(effect), (Target)null);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effects effects) {
        this.addChapterEffect(card, fromChapter, toChapter, effects, (Target)null);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effect effect, Target target) {
        this.addChapterEffect(card, fromChapter, toChapter, effect, target, false);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effects effects, Target target) {
        this.addChapterEffect(card, fromChapter, toChapter, effects, target, false);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effect effect, Target target, boolean optional) {
        this.addChapterEffect(card, fromChapter, toChapter, new Effects(effect), target, optional);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Consumer<TriggeredAbility> applier) {
        this.addChapterEffect(card, fromChapter, toChapter, false, applier);
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, Effects effects, Target target, boolean optional) {
        this.addChapterEffect(card, fromChapter, toChapter, optional, (TriggeredAbility ability) -> {
            for (Effect effect : effects) {
                if (effect == null) continue;
                ability.addEffect(effect.copy());
            }
            if (target != null) {
                ability.addTarget(target.copy());
            }
        });
    }

    public void addChapterEffect(Card card, SagaChapter fromChapter, SagaChapter toChapter, boolean optional, Consumer<TriggeredAbility> applier) {
        for (int i = fromChapter.getNumber(); i <= toChapter.getNumber(); ++i) {
            ChapterTriggeredAbility ability = new ChapterTriggeredAbility(SagaChapter.getChapter(i), toChapter, optional);
            applier.accept(ability);
            if (i > fromChapter.getNumber()) {
                ability.setRuleVisible(false);
            }
            card.addAbility(ability);
        }
    }

    public SagaChapter getMaxChapter() {
        return this.maxChapter;
    }

    public SagaAbility withShowSacText(boolean showSacText) {
        this.showSacText = showSacText;
        return this;
    }

    @Override
    public String getRule() {
        return (this.readAhead ? "<i>(Choose a chapter and start with that many lore counters. Add one after your draw step. Skipped chapters don't trigger." : "<i>(As this Saga enters and after your draw step, add a lore counter.") + (this.showSacText ? " Sacrifice after " + this.maxChapter.toString() + '.' : "") + ")</i> ";
    }

    @Override
    public SagaAbility copy() {
        return new SagaAbility(this);
    }

    public static boolean isChapterAbility(StackObject stackObject) {
        if (stackObject instanceof StackAbility) {
            return stackObject.getStackAbility() instanceof ChapterTriggeredAbility;
        }
        return false;
    }

    public static boolean isChapterAbility(TriggeredAbility ability) {
        return ability instanceof ChapterTriggeredAbility;
    }

    public static boolean isFinalAbility(Ability ability, int maxChapter) {
        return ability instanceof ChapterTriggeredAbility && ((ChapterTriggeredAbility)ability).getChapterFrom().getNumber() == maxChapter;
    }

    public static Ability makeGainReadAheadAbility() {
        return new GainReadAheadAbility();
    }
}

