/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SkipExtraTurnsEffect
extends ReplacementEffectImpl {
    private final boolean onlyOpponents;

    SkipExtraTurnsEffect(boolean onlyOpponents) {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.onlyOpponents = onlyOpponents;
    }

    private SkipExtraTurnsEffect(SkipExtraTurnsEffect effect) {
        super(effect);
        this.onlyOpponents = effect.onlyOpponents;
    }

    @Override
    public SkipExtraTurnsEffect copy() {
        return new SkipExtraTurnsEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        MageObject sourceObject = game.getObject(source);
        if (player != null && sourceObject != null) {
            game.informPlayers(sourceObject.getLogName() + ": Extra turn of " + player.getLogName() + " skipped");
        }
        return true;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.EXTRA_TURN;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.onlyOpponents || game.getPlayer(source.getControllerId()).hasOpponent(event.getPlayerId(), game);
    }
}

