/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.common.TransformedEffect;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.TransformAbility;
import mage.cards.Card;
import mage.constants.SpellAbilityCastMode;
import mage.constants.SpellAbilityType;
import mage.game.Game;

public class SpellTransformedAbility
extends SpellAbility {
    protected final String manaCost;

    public SpellTransformedAbility(Card card, String manaCost) {
        super(card.getSecondFaceSpellAbility());
        this.newId();
        this.setCardName(card.getSecondCardFace().getName());
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.setSpellAbilityCastMode(SpellAbilityCastMode.TRANSFORMED);
        this.manaCost = manaCost;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(manaCost));
        this.addSubAbility(new TransformAbility());
    }

    public SpellTransformedAbility(SpellAbility ability) {
        super(ability);
        this.newId();
        this.manaCost = null;
        this.getManaCosts().clear();
        this.getManaCostsToPay().clear();
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.setSpellAbilityCastMode(SpellAbilityCastMode.TRANSFORMED);
    }

    protected SpellTransformedAbility(SpellTransformedAbility ability) {
        super(ability);
        this.manaCost = ability.manaCost;
    }

    @Override
    public SpellTransformedAbility copy() {
        return new SpellTransformedAbility(this);
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (super.activate(game, allowedIdentifiers, noMana)) {
            game.getState().setValue("EnterTransformed" + this.getSourceId(), Boolean.TRUE);
            TransformedEffect effect = new TransformedEffect();
            game.addEffect(effect, this);
            effect.apply(game, this);
            return true;
        }
        return false;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Card card;
        if (super.canActivate(playerId, game).canActivate() && (card = game.getCard(this.getSourceId())) != null) {
            return card.getSpellAbility().canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }
}

