/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

public class ZoneChangeTriggeredAbility
extends TriggeredAbilityImpl {
    protected final Zone fromZone;
    protected final Zone toZone;

    public ZoneChangeTriggeredAbility(Zone fromZone, Zone toZone, Effect effect, String triggerPhrase, boolean optional) {
        this(toZone == null ? Zone.ALL : toZone, fromZone, toZone, effect, triggerPhrase, optional);
    }

    public ZoneChangeTriggeredAbility(Zone worksInZone, Zone fromZone, Zone toZone, Effect effect, String triggerPhrase, boolean optional) {
        super(worksInZone, effect, optional);
        if (fromZone == Zone.BATTLEFIELD) {
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.fromZone = fromZone;
        this.toZone = toZone;
        this.setTriggerPhrase(triggerPhrase);
    }

    public ZoneChangeTriggeredAbility(Zone toZone, Effect effect, String triggerPhrase, boolean optional) {
        super(toZone, effect, optional);
        this.fromZone = null;
        this.toZone = toZone;
        this.setTriggerPhrase(triggerPhrase);
    }

    protected ZoneChangeTriggeredAbility(ZoneChangeTriggeredAbility ability) {
        super(ability);
        this.fromZone = ability.fromZone;
        this.toZone = ability.toZone;
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
            if (!(this.fromZone != null && zEvent.getFromZone() != this.fromZone || this.toZone != null && zEvent.getToZone() != this.toZone)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ZoneChangeTriggeredAbility copy() {
        return new ZoneChangeTriggeredAbility(this);
    }

    public Zone getFromZone() {
        return this.fromZone;
    }

    public Zone getToZone() {
        return this.toZone;
    }
}

