/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.filter.FilterSpell;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.ManaPoolItem;
import mage.players.Player;

public class ManaSpentDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private final FilterSpell filter;

    public ManaSpentDelayedTriggeredAbility(Effect effect, FilterSpell filter) {
        super(effect, Duration.Custom, true, false);
        this.filter = filter;
        this.setTriggerPhrase("When you spend this mana to cast " + filter.getMessage() + ", ");
    }

    protected ManaSpentDelayedTriggeredAbility(ManaSpentDelayedTriggeredAbility ability) {
        super(ability);
        this.filter = ability.filter;
    }

    @Override
    public ManaSpentDelayedTriggeredAbility copy() {
        return new ManaSpentDelayedTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        block5: {
            block4: {
                if (!this.getSourceId().equals(event.getSourceId())) {
                    return false;
                }
                Permanent sourcePermanent = this.getSourcePermanentOrLKI(game);
                if (sourcePermanent == null) break block4;
                if (!sourcePermanent.getAbilities(game).stream().map(Ability::getOriginalId).map(UUID::toString).noneMatch(event.getData()::equals)) break block5;
            }
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && this.filter.match(spell, spell.getControllerId(), this, game);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInactive(Game game) {
        if (super.isInactive(game)) {
            return true;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) return true;
        if (!player.getManaPool().getManaItems().stream().map(ManaPoolItem::getSourceId).noneMatch(this.getSourceId()::equals)) return false;
        return true;
    }
}

