/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.common.delayed;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PactEffect
extends OneShotEffect {
    private final ManaCosts cost;

    public PactEffect(ManaCosts cost) {
        super(Outcome.Neutral);
        this.cost = cost;
        this.staticText = "pay " + cost.getText() + ". If you don't, you lose the game";
    }

    protected PactEffect(PactEffect effect) {
        super(effect);
        this.cost = effect.cost.copy();
    }

    @Override
    public PactEffect copy() {
        return new PactEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            if (player.chooseUse(Outcome.Benefit, "Pay " + this.cost.getText() + '?', source, game)) {
                this.cost.clearPaid();
                if (this.cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            player.lost(game);
            return true;
        }
        return false;
    }
}

