/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Arrays;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.AbilityType;
import mage.constants.ColoredManaSymbol;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.ManaSpentToCastWatcher;

public enum AdamantCondition implements Condition
{
    WHITE(ColoredManaSymbol.W),
    BLUE(ColoredManaSymbol.U),
    BLACK(ColoredManaSymbol.B),
    RED(ColoredManaSymbol.R),
    GREEN(ColoredManaSymbol.G),
    COLORLESS(null, true),
    ANY(null);

    private final ColoredManaSymbol coloredManaSymbol;
    private final boolean colorless;

    private AdamantCondition(ColoredManaSymbol coloredManaSymbol) {
        this(coloredManaSymbol, false);
    }

    private AdamantCondition(ColoredManaSymbol coloredManaSymbol, boolean colorless) {
        this.coloredManaSymbol = coloredManaSymbol;
        this.colorless = colorless;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (source.getAbilityType() == AbilityType.SPELL) {
            if (this.colorless) {
                return source.getManaCostsToPay().getUsedManaToPay().getColorless() > 2;
            }
            if (this.coloredManaSymbol == null) {
                return Arrays.stream(ColoredManaSymbol.values()).map(source.getManaCostsToPay().getUsedManaToPay()::getColor).anyMatch(i -> i > 2);
            }
            return source.getManaCostsToPay().getUsedManaToPay().getColor(this.coloredManaSymbol) > 2;
        }
        ManaSpentToCastWatcher watcher = game.getState().getWatcher(ManaSpentToCastWatcher.class);
        if (watcher == null) {
            return false;
        }
        Mana payment = watcher.getManaPayment(CardUtil.getSourceStackMomentReference(game, source));
        if (payment == null) {
            return false;
        }
        if (this.colorless) {
            return payment.getColorless() > 2;
        }
        if (this.coloredManaSymbol == null) {
            return Arrays.stream(ColoredManaSymbol.values()).map(payment::getColor).anyMatch(i -> i > 2);
        }
        return payment.getColor(this.coloredManaSymbol) > 2;
    }

    @Override
    public boolean caresAboutManaColor() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("at least three ");
        if (this.coloredManaSymbol == null && !this.colorless) {
            sb.append("mana of the same color");
        } else {
            sb.append(this.coloredManaSymbol != null ? this.coloredManaSymbol.getColorName() : "colorless");
            sb.append(" mana");
        }
        sb.append(" was spent to cast it");
        return sb.toString();
    }
}

