/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.game.permanent.Permanent;

public enum AttachedToTappedCondition implements Condition
{
    TAPPED(true),
    UNTAPPED(false);

    private final boolean tapped;

    private AttachedToTappedCondition(boolean tapped) {
        this.tapped = tapped;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent attachment = game.getPermanent(source.getSourceId());
        if (attachment == null || attachment.getAttachedTo() == null) {
            return false;
        }
        Permanent attachedTo = game.getPermanent(attachment.getAttachedTo());
        if (attachedTo == null) {
            return false;
        }
        return attachedTo.isTapped() == this.tapped;
    }
}

