/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.ComparisonType;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class CardsInHandCondition
implements Condition {
    private final ComparisonType type;
    private final int count;
    private final TargetController targetController;

    public CardsInHandCondition(ComparisonType type, int count) {
        this(type, count, TargetController.YOU);
    }

    public CardsInHandCondition(ComparisonType type, int count, TargetController targetController) {
        this.type = type;
        this.count = count;
        this.targetController = targetController;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean conditionApplies = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            switch (this.targetController) {
                case YOU: {
                    conditionApplies = ComparisonType.compare(game.getPlayer(source.getControllerId()).getHand().size(), this.type, this.count);
                    break;
                }
                case ACTIVE: {
                    Player player = game.getPlayer(game.getActivePlayerId());
                    if (player == null) break;
                    conditionApplies = ComparisonType.compare(player.getHand().size(), this.type, this.count);
                    break;
                }
                case ANY: {
                    for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                        Player player = game.getPlayer(playerId);
                        if (player == null || !ComparisonType.compare(player.getHand().size(), this.type, this.count)) continue;
                        conditionApplies = true;
                    }
                    break;
                }
                case EACH_PLAYER: {
                    boolean conflict = false;
                    for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                        Player player = game.getPlayer(playerId);
                        if (player == null || ComparisonType.compare(player.getHand().size(), this.type, this.count)) continue;
                        conflict = true;
                        break;
                    }
                    conditionApplies = !conflict;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Value of TargetController not supported for this class.");
                }
            }
        }
        return conditionApplies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("if ");
        switch (this.targetController) {
            case YOU: {
                sb.append("you have ");
                break;
            }
            case ACTIVE: {
                sb.append("that player has ");
                break;
            }
            case EACH_PLAYER: {
                sb.append("each player has ");
                break;
            }
            case ANY: {
                sb.append("a player has ");
            }
        }
        switch (this.type) {
            case FEWER_THAN: {
                sb.append(CardUtil.numberToText(this.count - 1));
                sb.append(" or fewer ");
                break;
            }
            case MORE_THAN: {
                sb.append(CardUtil.numberToText(this.count + 1));
                sb.append(" or more ");
                break;
            }
            case OR_LESS: {
                sb.append(CardUtil.numberToText(this.count));
                sb.append(" or fewer ");
                break;
            }
            case OR_GREATER: {
                sb.append(CardUtil.numberToText(this.count));
                sb.append(" or more ");
                break;
            }
            case EQUAL_TO: {
                if (this.count > 0) {
                    sb.append("exactly ");
                    sb.append(CardUtil.numberToText(this.count));
                    sb.append(" ");
                    break;
                }
                sb.append("no ");
            }
        }
        sb.append("cards in hand");
        return sb.toString();
    }
}

