/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.PhaseStep;
import mage.game.Game;

public class IsStepCondition
implements Condition {
    protected PhaseStep phaseStep;
    protected boolean onlyDuringYourSteps;
    private static final IsStepCondition myUpkeep = new IsStepCondition(PhaseStep.UPKEEP, true);

    public static IsStepCondition getMyUpkeep() {
        return myUpkeep;
    }

    public IsStepCondition(PhaseStep phaseStep) {
        this(phaseStep, true);
    }

    public IsStepCondition(PhaseStep phaseStep, boolean onlyDuringYourSteps) {
        this.phaseStep = phaseStep;
        this.onlyDuringYourSteps = onlyDuringYourSteps;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return this.phaseStep == game.getTurnStepType() && (!this.onlyDuringYourSteps || game.isActivePlayer(source.getControllerId()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("during ");
        if (this.onlyDuringYourSteps) {
            sb.append("your ").append(this.phaseStep.getStepText());
        } else if (this.phaseStep == PhaseStep.UPKEEP) {
            sb.append("any upkeep step");
        } else {
            sb.append("the ").append(this.phaseStep.getStepText());
        }
        return sb.toString();
    }
}

