/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.AbilityType;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.ManaSpentToCastWatcher;

public enum ManaWasSpentCondition implements Condition
{
    WHITE(ColoredManaSymbol.W),
    BLUE(ColoredManaSymbol.U),
    BLACK(ColoredManaSymbol.B),
    RED(ColoredManaSymbol.R),
    GREEN(ColoredManaSymbol.G),
    COLORLESS(ManaType.COLORLESS);

    protected final ColoredManaSymbol coloredManaSymbol;
    protected final ManaType manaType;

    private ManaWasSpentCondition(ColoredManaSymbol coloredManaSymbol) {
        this(coloredManaSymbol, null);
    }

    private ManaWasSpentCondition(ManaType manaType) {
        this(null, manaType);
    }

    private ManaWasSpentCondition(ColoredManaSymbol coloredManaSymbol, ManaType manaType) {
        this.coloredManaSymbol = coloredManaSymbol;
        this.manaType = manaType;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Mana payment;
        if (source.getAbilityType() == AbilityType.SPELL) {
            return source.getManaCostsToPay().getUsedManaToPay().getColor(this.coloredManaSymbol) > 0;
        }
        ManaSpentToCastWatcher watcher = game.getState().getWatcher(ManaSpentToCastWatcher.class);
        if (watcher != null && (payment = watcher.getManaPayment(CardUtil.getSourceStackMomentReference(game, source))) != null) {
            if (this.coloredManaSymbol != null) {
                return payment.getColor(this.coloredManaSymbol) > 0;
            }
            if (this.manaType != null) {
                return payment.get(this.manaType) > 0;
            }
        }
        return false;
    }

    public String toString() {
        if (this.coloredManaSymbol != null) {
            return "{" + (Object)((Object)this.coloredManaSymbol) + "} was spent to cast it";
        }
        if (this.manaType != null) {
            return "{" + (Object)((Object)this.manaType) + "} was spent to cast it";
        }
        return "";
    }

    @Override
    public boolean caresAboutManaColor() {
        return true;
    }
}

