/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.IntCompareCondition;
import mage.constants.ComparisonType;
import mage.game.Game;
import mage.watchers.common.PlayerLostLifeWatcher;

public class OpponentLostLifeCondition
extends IntCompareCondition {
    public OpponentLostLifeCondition(ComparisonType type, int value) {
        super(type, value);
    }

    @Override
    protected int getInputValue(Game game, Ability source) {
        int maxLostLive = 0;
        PlayerLostLifeWatcher watcher = game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (watcher != null) {
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                int lostLive = watcher.getLifeLost(opponentId);
                if (lostLive <= maxLostLive) continue;
                maxLostLive = lostLive;
            }
        }
        return maxLostLive;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("if an opponent lost ");
        switch (this.type) {
            case MORE_THAN: {
                sb.append(this.value + 1).append(" or more life this turn");
                break;
            }
            case OR_GREATER: {
                sb.append(this.value).append(" or more life this turn");
                break;
            }
            case EQUAL_TO: {
                sb.append(this.value).append(" life this turn");
                break;
            }
            case FEWER_THAN: {
                sb.append(" less than ").append(this.value).append(" life this turn");
                break;
            }
            case OR_LESS: {
                sb.append(this.value).append(" or less life this turn");
            }
        }
        return sb.toString();
    }
}

