/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.condition.common;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class SacrificedPermanentCondition
implements Condition {
    private final FilterPermanent filter;
    private boolean useThisWay = false;

    public SacrificedPermanentCondition(FilterPermanent filter) {
        this.filter = filter;
    }

    public SacrificedPermanentCondition(FilterPermanent filter, boolean useThisWay) {
        this.filter = filter;
        this.useThisWay = useThisWay;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return CardUtil.castStream(source.getCosts().stream(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).anyMatch(permanent -> this.filter.match((Permanent)permanent, source.getControllerId(), source, game));
    }

    public String toString() {
        if (this.useThisWay) {
            return "if " + this.filter.getMessage() + " was sacrificed this way";
        }
        return "if the sacrificed " + this.filter.getMessage();
    }
}

